/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql;

import jakarta.data.repository.DataRepository;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;
import org.glassfish.main.jnosql.hk2types.GeneralInterfaceModel;
import org.glassfish.main.jnosql.jakartapersistence.BaseGlassFishClassScanner;
import org.glassfish.main.jnosql.jakartapersistence.GlassFishJakartaPersistenceClassScanner;

public class GlassFishNoSqlClassScanner
extends BaseGlassFishClassScanner
implements ClassScanner {
    private static final System.Logger LOG = System.getLogger(GlassFishJakartaPersistenceClassScanner.class.getName());

    @Override
    protected boolean isEnabled() {
        return true;
    }

    public Set<Class<?>> entities() {
        Set<Class<?>> result = this.findClassesWithAnnotation(Entity.class);
        LOG.log(System.Logger.Level.DEBUG, () -> "Found NoSql entities: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> repositories() {
        Set<Class<?>> result = this.repositoriesStream().collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected NoSql repository interfaces: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> embeddables() {
        Set<Class<?>> result = this.findClassesWithAnnotation(Embeddable.class);
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected NoSql embeddables: " + String.valueOf(result));
        return result;
    }

    public <T extends DataRepository<?, ?>> Set<Class<?>> repositories(Class<T> filter) {
        Objects.requireNonNull(filter, "filter is required");
        return this.repositoriesStream().filter(filter::isAssignableFrom).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<?>> repositoriesStandard() {
        Set<Class<?>> result = this.repositoriesStreamMatching(x$0 -> this.isSupportedStandardInterface((GeneralInterfaceModel)x$0)).collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected standard NoSql repository interfaces: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> customRepositories() {
        Set<Class<?>> result = this.repositoriesStreamMatching(x$0 -> this.isNotSupportedStandardInterface((GeneralInterfaceModel)x$0)).collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected custom NoSql interfaces: " + String.valueOf(result));
        return result;
    }

    @Override
    protected boolean isSupportedEntityType(GeneralInterfaceModel entityType) {
        return null != entityType.getAnnotation(Entity.class);
    }

    @Override
    protected String getProviderName() {
        return "Eclipse_JNoSQL";
    }
}

