/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAResource;

public class NetXAConnection {
    private NetConnection netCon;

    public NetXAConnection(LogWriter logWriter, String string, String string2, BasicClientDataSource basicClientDataSource, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        this.netCon = this.createNetConnection(logWriter, string, string2, basicClientDataSource, n, bl, clientPooledConnection);
        this.checkPlatformVersion();
    }

    public void setCorrelatorToken(byte[] byArray) {
        this.netCon.crrtkn_ = byArray;
    }

    void setNetXAResource(NetXAResource netXAResource) {
        this.netCon.xares_ = netXAResource;
    }

    private void writeLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXACommit(this.netCon);
    }

    private void readLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXACommit(this.netCon);
    }

    private void writeLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXARollback(this.netCon);
    }

    private void readLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXARollback(this.netCon);
    }

    void writeTransactionStart(ClientStatement clientStatement) throws SqlException {
        if (!this.netCon.isXAConnection()) {
            return;
        }
        int n = this.netCon.getXAState();
        this.netCon.xares_.exceptionsOnXA = null;
    }

    void writeCommit() throws SqlException {
        int n = this.netCon.getXAState();
        if (n == 0) {
            this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
            this.writeLocalXACommit_();
        }
    }

    void readCommit() throws SqlException {
        int n = this.netCon.getXAState();
        NetXACallInfo netXACallInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        netXACallInfo.xaRetVal_ = 0;
        if (n == 0) {
            this.readLocalXACommit_();
        }
        if (netXACallInfo.xaRetVal_ != 0) {
            netXACallInfo.xaFunction_ = 1;
            this.netCon.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
            netXACallInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
    }

    void writeRollback() throws SqlException {
        NetXAResource cfr_ignored_0 = this.netCon.xares_;
        this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
        this.writeLocalXARollback_();
    }

    void readRollback() throws SqlException {
        NetXACallInfo netXACallInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        netXACallInfo.xaRetVal_ = 0;
        this.readLocalXARollback_();
        if (netXACallInfo.xaRetVal_ != 0) {
            netXACallInfo.xaFunction_ = 6;
            this.netCon.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
            netXACallInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
        this.netCon.setXAState(0);
    }

    public NetConnection getNetConnection() {
        return this.netCon;
    }

    private void checkPlatformVersion() throws SqlException {
        int n = 8;
        if (this.netCon.xaHostVersion_ >= n) {
            return;
        }
        String string = null;
        string = "Linux, Unix, Windows";
        throw new SqlException(this.netCon.agent_.logWriter_, new ClientMessageId("XN012.S"), string, n, this.netCon.xaHostVersion_);
    }

    private NetConnection createNetConnection(LogWriter logWriter, String string, String string2, BasicClientDataSource basicClientDataSource, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        return (NetConnection)ClientAutoloadedDriver.getFactory().newNetConnection(logWriter, string, string2, basicClientDataSource, n, bl, clientPooledConnection);
    }
}

