/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class DataModel<E>
implements Iterable<E> {
    private static final DataModelListener[] EMPTY_DATA_MODEL_LISTENER = new DataModelListener[0];
    private List<DataModelListener> listeners = null;

    public abstract boolean isRowAvailable();

    public abstract int getRowCount();

    public abstract E getRowData();

    public abstract int getRowIndex();

    public abstract void setRowIndex(int var1);

    public abstract Object getWrappedData();

    public abstract void setWrappedData(Object var1);

    public void addDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<DataModelListener>();
        }
        this.listeners.add(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        if (this.listeners == null) {
            return EMPTY_DATA_MODEL_LISTENER;
        }
        return this.listeners.toArray(new DataModelListener[this.listeners.size()]);
    }

    public void removeDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new DataModelIterator(this);
    }

    private static final class DataModelIterator<T>
    implements Iterator<T> {
        private DataModel<T> model;
        private int index;

        DataModelIterator(DataModel<T> model) {
            this.model = model;
            this.model.setRowIndex(this.index);
        }

        @Override
        public boolean hasNext() {
            return this.model.isRowAvailable();
        }

        @Override
        public T next() {
            if (!this.model.isRowAvailable()) {
                throw new NoSuchElementException();
            }
            T o = this.model.getRowData();
            this.model.setRowIndex(++this.index);
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

