/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.OutputStreamFactory;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.transport.ConnectionImpl;
import com.sun.corba.ee.impl.transport.EventHandlerBase;
import com.sun.corba.ee.spi.extension.LoadBalancingPolicy;
import com.sun.corba.ee.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.EventHandler;
import com.sun.corba.ee.spi.transport.InboundConnectionCache;
import com.sun.corba.ee.spi.transport.Selector;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.net.Socket;
import java.util.Iterator;

@Transport
public abstract class AcceptorBase
extends EventHandlerBase
implements Acceptor,
Work,
SocketInfo,
LegacyServerSocketEndPointInfo {
    protected ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected int port;
    protected long enqueueTime;
    protected boolean initialized = false;
    protected String type = "";
    protected String name = "";
    protected String hostname;
    protected int locatorPort;
    protected InboundConnectionCache connectionCache;

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getInterfaceName() {
        String result = this.name.equals("NO_NAME") ? this.toString() : this.name;
        return result;
    }

    @Override
    public String getName() {
        return this.getInterfaceName();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    public AcceptorBase(ORB orb, int port, String name, String type) {
        this.orb = orb;
        this.setWork(this);
        this.hostname = orb.getORBData().getORBServerHost();
        this.name = "NO_NAME";
        this.locatorPort = -1;
        this.port = port;
        this.name = name;
        this.type = type;
    }

    @Override
    @Transport
    public void processSocket(Socket socket) {
        ConnectionImpl connection = new ConnectionImpl(this.orb, this, socket);
        this.getConnectionCache().put(this, connection);
        if (connection.shouldRegisterServerReadEvent()) {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerForEvent(connection.getEventHandler());
        }
        this.getConnectionCache().reclaim();
    }

    @Override
    @Transport
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase) {
        Iterator<TaggedProfileTemplate> iterator = iorTemplate.iteratorById(0);
        String hname = this.orb.getORBData().getORBServerHost();
        if (iterator.hasNext()) {
            if (!this.type.startsWith("SSL")) {
                IIOPAddress iiopAddress = IIOPFactories.makeIIOPAddress(hname, this.port);
                AlternateIIOPAddressComponent iiopAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(iiopAddress);
                while (iterator.hasNext()) {
                    TaggedProfileTemplate taggedProfileTemplate = iterator.next();
                    taggedProfileTemplate.add(iiopAddressComponent);
                }
            }
        } else {
            IIOPProfileTemplate iiopProfile = this.makeIIOPProfileTemplate(policies, codebase);
            iorTemplate.add(iiopProfile);
        }
    }

    @Transport
    protected final IIOPProfileTemplate makeIIOPProfileTemplate(Policies policies, String codebase) {
        GIOPVersion version = this.orb.getORBData().getGIOPVersion();
        int templatePort = policies.forceZeroPort() ? 0 : (policies.isTransient() ? this.port : this.orb.getLegacyServerSocketManager().legacyGetPersistentServerPort("IIOP_CLEAR_TEXT"));
        IIOPAddress addr = IIOPFactories.makeIIOPAddress(this.hostname, templatePort);
        IIOPProfileTemplate iiopProfile = IIOPFactories.makeIIOPProfileTemplate(this.orb, version, addr);
        if (version.supportsIORIIOPProfileComponents()) {
            LoadBalancingPolicy lbPolicy;
            iiopProfile.add(IIOPFactories.makeCodeSetsComponent(this.orb));
            iiopProfile.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
            RequestPartitioningPolicy rpPolicy = (RequestPartitioningPolicy)policies.get_effective_policy(0x53550003);
            if (rpPolicy != null) {
                iiopProfile.add(IIOPFactories.makeRequestPartitioningComponent(rpPolicy.getValue()));
            }
            if ((lbPolicy = (LoadBalancingPolicy)policies.get_effective_policy(0x53550005)) != null) {
                iiopProfile.add(IIOPFactories.makeLoadBalancingComponent(lbPolicy.getValue()));
            }
            if (codebase != null && !codebase.equals("")) {
                iiopProfile.add(IIOPFactories.makeJavaCodebaseComponent(codebase));
            }
            if (this.orb.getORBData().isJavaSerializationEnabled()) {
                iiopProfile.add(IIOPFactories.makeJavaSerializationComponent());
            }
        }
        return iiopProfile;
    }

    public String toString() {
        return this.toStringName() + "[" + this.port + " " + this.type + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
    }

    protected String toStringName() {
        return "SocketOrChannelAcceptorImpl";
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public int getLocatorPort() {
        return this.locatorPort;
    }

    @Override
    public void setLocatorPort(int port) {
        this.locatorPort = port;
    }

    @Override
    public InboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public String getConnectionCacheType() {
        return "SocketOrChannelConnectionCache";
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public String getMonitoringName() {
        return "AcceptedConnections";
    }

    @Override
    public synchronized boolean initialized() {
        return this.initialized;
    }

    @Override
    public void setConnectionCache(InboundConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    @Override
    public Acceptor getAcceptor() {
        return this;
    }

    @Override
    public Connection getConnection() {
        throw new RuntimeException("Should not happen.");
    }

    @Override
    public CDROutputObject createOutputObject(ORB broker, MessageMediator messageMediator) {
        return OutputStreamFactory.newCDROutputObject(broker, messageMediator, messageMediator.getReplyHeader(), messageMediator.getStreamFormatVersion());
    }

    @Override
    public boolean shouldRegisterAcceptEvent() {
        return true;
    }

    @Override
    public int getInterestOps() {
        return 16;
    }
}

