/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum GlassFishVariable {
    CONFIG_ROOT("AS_CONFIG", "com.sun.aas.configRoot"),
    DERBY_ROOT("AS_DERBY_INSTALL", "com.sun.aas.derbyRoot"),
    DOMAINS_ROOT("AS_DEF_DOMAINS_PATH", "com.sun.aas.domainsRoot"),
    HOST_NAME(null, "com.sun.aas.hostName"),
    JAVA_HOME("JAVA_HOME", "java.home"),
    JAVA_ROOT("AS_JAVA", "com.sun.aas.javaRoot"),
    OSGI_PLATFORM("GlassFish_Platform"),
    IMQ_BIN("AS_IMQ_BIN", "com.sun.aas.imqBin"),
    IMQ_LIB("AS_IMQ_LIB", "com.sun.aas.imqLib"),
    INSTALL_ROOT("AS_INSTALL", "com.sun.aas.installRoot"),
    INSTANCE_ROOT(null, "com.sun.aas.instanceRoot"),
    NODES_ROOT("AS_DEF_NODES_PATH", "com.sun.aas.agentRoot"),
    PRODUCT_ROOT(null, "com.sun.aas.productRoot"),
    KEYSTORE_FILE("AS_KEYSTORE_FILE", "javax.net.ssl.keyStore"),
    KEYSTORE_TYPE("AS_KEYSTORE_TYPE", "javax.net.ssl.keyStoreType"),
    KEYSTORE_PASSWORD(null, "javax.net.ssl.keyStorePassword"),
    TRUSTSTORE_FILE("AS_TRUSTSTORE_FILE", "javax.net.ssl.trustStore"),
    TRUSTSTORE_TYPE("AS_TRUSTSTORE_TYPE", "javax.net.ssl.trustStoreType"),
    TRUSTSTORE_PASSWORD(null, "javax.net.ssl.trustStorePassword"),
    TIMEOUT_START_SERVER("AS_START_TIMEOUT", null),
    TIMEOUT_STOP_SERVER("AS_STOP_TIMEOUT", null);

    private final String envName;
    private final String sysPropName;

    private GlassFishVariable(String name) {
        this(name, name);
    }

    private GlassFishVariable(String envName, String sysPropName) {
        this.envName = envName;
        this.sysPropName = sysPropName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public String toExpression() {
        return "${" + this.getPropertyName() + "}";
    }

    public String getPropertyName() {
        return this.getSystemPropertyName();
    }

    public String getSystemPropertyName() {
        return this.sysPropName;
    }

    public static Map<String, String> getEnvToSystemPropertyMapping() {
        return Arrays.stream(GlassFishVariable.values()).filter(m -> m.getEnvName() != null && m.getSystemPropertyName() != null).collect(Collectors.toMap(GlassFishVariable::getEnvName, GlassFishVariable::getSystemPropertyName));
    }
}

