/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;

public final class Environment {
    private static String PREFIX = "AS_ADMIN_";
    private static String SHORT_PREFIX = "AS_";
    private final Map<String, String> env = new HashMap<String, String>();
    private boolean debug;
    private boolean trace;
    private File logfile;
    private Formatter formatter;

    public static void setPrefix(String p) {
        PREFIX = p;
    }

    public static String getPrefix() {
        return PREFIX;
    }

    public static void setShortPrefix(String p) {
        SHORT_PREFIX = p;
    }

    public static String getDebugVar() {
        return SHORT_PREFIX + "DEBUG";
    }

    public Environment() {
        this(false);
    }

    public Environment(boolean ignoreEnvironment) {
        if (ignoreEnvironment) {
            return;
        }
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().startsWith(PREFIX)) continue;
            this.env.put(e.getKey().toUpperCase(Locale.ENGLISH), e.getValue());
        }
        String debugFlag = "Debug";
        String debugProp = Environment.getDebugVar();
        this.debug = System.getProperty(debugFlag) != null || Boolean.parseBoolean(System.getenv(debugProp)) || Boolean.getBoolean(debugProp);
        String traceProp = SHORT_PREFIX + "TRACE";
        this.trace = System.getProperty(traceProp) != null || Boolean.parseBoolean(System.getenv(traceProp)) || Boolean.getBoolean(traceProp);
        String logProp = SHORT_PREFIX + "LOGFILE";
        String fname = System.getProperty(logProp);
        if (fname == null) {
            fname = System.getenv(logProp);
        }
        if (fname != null) {
            this.logfile = Environment.prepareFile(new File(fname));
        }
        String formatterClass = this.env.get(PREFIX + "LOG_FORMATTER");
        try {
            this.formatter = formatterClass == null ? null : (Formatter)Class.forName(formatterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("This is not a valid formatter: " + formatterClass, e);
        }
    }

    public boolean getBooleanOption(String name) {
        return Boolean.parseBoolean(this.env.get(this.optionToEnv(name)));
    }

    public String getStringOption(String name) {
        return this.env.get(this.optionToEnv(name));
    }

    public boolean hasOption(String name) {
        return this.env.containsKey(this.optionToEnv(name));
    }

    public String get(String name) {
        return this.env.get(name);
    }

    public String put(String name, String value) {
        return this.env.put(name, value);
    }

    public void remove(String name) {
        this.env.remove(name);
    }

    public String putOption(String name, String value) {
        return this.env.put(this.optionToEnv(name), value);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.env.entrySet();
    }

    private String optionToEnv(String name) {
        return PREFIX + name.replace('-', '_').toUpperCase(Locale.ENGLISH);
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean trace() {
        return this.trace;
    }

    public File getDebugLogfile() {
        return this.logfile;
    }

    public Formatter getLogFormatter() {
        return this.formatter;
    }

    private static File prepareFile(File file) {
        try {
            if (file.isFile()) {
                if (file.canWrite()) {
                    return file;
                }
                throw new IllegalStateException("The file already exists, but we cannot write to it: " + String.valueOf(file));
            }
            File dir = file.getCanonicalFile().getParentFile();
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new IllegalStateException("The directory " + String.valueOf(dir) + " doesn't exist and isn't even possible to create it. Output to file '" + String.valueOf(file) + "' is not possible.");
            }
            if (file.createNewFile()) {
                return file;
            }
            throw new IllegalStateException("Seems somebody else created the file right now, was it intentional? " + String.valueOf(file));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create a log file: " + String.valueOf(file), e);
        }
    }
}

