/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.Collectors;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class ExcludeFieldsSupport {
    private final BitSet excludedAttributes = new BitSet(SupplementalAttribute.values().length);

    public static SupplementalAttribute getById(String id) {
        for (SupplementalAttribute value : SupplementalAttribute.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }

    public void setExcludedFields(String excludeFields) {
        String[] fields;
        this.excludedAttributes.clear();
        if (excludeFields == null || excludeFields.isEmpty()) {
            return;
        }
        for (String field : fields = excludeFields.split(",")) {
            SupplementalAttribute found = ExcludeFieldsSupport.getById(field);
            if (found == null) {
                GlassFishLoggingTracer.error(this.getClass(), "Ignoring excluded field because no such exists: " + field);
                continue;
            }
            this.excludedAttributes.set(found.ordinal());
        }
    }

    public boolean isSet(SupplementalAttribute attribute) {
        return this.excludedAttributes.get(attribute.ordinal());
    }

    public String toString() {
        return Arrays.stream(SupplementalAttribute.values()).filter(this::isSet).map(SupplementalAttribute::getId).collect(Collectors.joining(","));
    }

    public static enum SupplementalAttribute {
        TID("tid"),
        LEVEL_VALUE("levelValue");

        private final String id;

        private SupplementalAttribute(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

