/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;
import org.jvnet.hk2.component.MultiMap;

class UploadedFilesManager {
    private static final System.Logger LOG = System.getLogger(UploadedFilesManager.class.getName());
    private final ActionReport report;
    private MultiMap<String, File> optionNameToFileMap;
    private PayloadFilesManager.Temp payloadFilesMgr = null;

    UploadedFilesManager(ActionReport report, Payload.Inbound inboundPayload, String applicationRoot) throws IOException, Exception {
        this.report = report;
        this.extractFiles(inboundPayload, applicationRoot);
    }

    MultiMap<String, File> optionNameToFileMap() {
        return this.optionNameToFileMap;
    }

    public void close() {
        if (this.payloadFilesMgr != null) {
            this.payloadFilesMgr.cleanup();
        }
    }

    private void extractFiles(Payload.Inbound inboundPayload, String applicationRoot) throws Exception {
        if (inboundPayload == null) {
            return;
        }
        File uniqueSubdirUnderApplications = this.chooseTempDirParent(applicationRoot);
        this.payloadFilesMgr = new PayloadFilesManager.Temp(uniqueSubdirUnderApplications, this.report);
        Map payloadFiles = this.payloadFilesMgr.processPartsExtended(inboundPayload);
        this.optionNameToFileMap = new MultiMap();
        for (Map.Entry e : payloadFiles.entrySet()) {
            String optionName = ((Properties)e.getValue()).getProperty("data-request-name");
            if (optionName == null) continue;
            LOG.log(System.Logger.Level.DEBUG, () -> "UploadedFilesManager: map " + optionName + " to " + String.valueOf(e.getKey()));
            this.optionNameToFileMap.add((Object)optionName, (Object)((File)e.getKey()));
        }
    }

    private File chooseTempDirParent(String applicationRoot) throws IOException {
        File appRoot = new File(applicationRoot);
        if (!(appRoot.isDirectory() || appRoot.exists() || appRoot.mkdirs())) {
            throw new IOException("Could not create the directory " + String.valueOf(appRoot) + "; no further information is available.");
        }
        return appRoot;
    }
}

