/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import org.glassfish.pfl.tf.timer.spi.Statistics;

public class StatisticsAccumulator {
    private double max;
    private double min;
    double sampleSum;
    double sampleSquareSum;
    private long sampleCount;
    private String unit;
    private Statistics stats;

    public String unit() {
        return this.unit;
    }

    public long count() {
        return this.sampleCount;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double average() {
        return this.sampleSum / (double)this.sampleCount;
    }

    public double standardDeviation() {
        double sampleSumSquare = this.sampleSum * this.sampleSum;
        return Math.sqrt((this.sampleSquareSum - sampleSumSquare / (double)this.sampleCount) / (double)(this.sampleCount - 1L));
    }

    public void sample(double value) {
        ++this.sampleCount;
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.sampleSum += value;
        this.sampleSquareSum += value * value;
    }

    public synchronized Statistics getStats() {
        if (this.stats == null || this.stats.count() != this.sampleCount) {
            this.stats = new Statistics(this.sampleCount, this.min, this.max, this.average(), this.standardDeviation());
        }
        return this.stats;
    }

    public void augment(StatisticsAccumulator acc) {
        if (!this.unit.equals(acc.unit)) {
            throw new IllegalArgumentException("Units must match: this = " + this.unit + " other = " + acc.unit);
        }
        this.sampleCount += acc.count();
        if (acc.min < this.min) {
            this.min = acc.min;
        }
        if (acc.max() > this.max) {
            this.max = acc.max;
        }
        this.sampleSum += acc.sampleSum;
        this.sampleSquareSum += acc.sampleSquareSum;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return "Minimum Value = " + this.min + " " + this.unit + " Maximum Value = " + this.max + " " + this.unit + " Average Value = " + this.average() + " " + this.unit + " Standard Deviation = " + this.standardDeviation() + " " + this.unit + " Samples Collected = " + this.sampleCount;
    }

    public StatisticsAccumulator(String unit) {
        this.unit = unit;
        this.clearState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
        StatisticsAccumulator statisticsAccumulator = this;
        synchronized (statisticsAccumulator) {
            this.stats = null;
        }
    }

    public void unitTestValidate(String expectedUnit, double expectedMin, double expectedMax, long expectedSampleCount, double expectedAverage, double expectedStandardDeviation) {
        if (!expectedUnit.equals(this.unit)) {
            throw new RuntimeException("Unit is not same as expected Unit\nUnit = " + this.unit + "ExpectedUnit = " + expectedUnit);
        }
        if (this.min != expectedMin) {
            throw new RuntimeException("Minimum value is not same as expected minimum value\nMin Value = " + this.min + "Expected Min Value = " + expectedMin);
        }
        if (this.max != expectedMax) {
            throw new RuntimeException("Maximum value is not same as expected maximum value\nMax Value = " + this.max + "Expected Max Value = " + expectedMax);
        }
        if (this.sampleCount != expectedSampleCount) {
            throw new RuntimeException("Sample count is not same as expected Sample Count\nSampleCount = " + this.sampleCount + "Expected Sample Count = " + expectedSampleCount);
        }
        if (this.average() != expectedAverage) {
            throw new RuntimeException("Average is not same as expected Average\nAverage = " + this.average() + "Expected Average = " + expectedAverage);
        }
        double difference = Math.abs(this.standardDeviation() - expectedStandardDeviation);
        if (difference > 1.0) {
            throw new RuntimeException("Standard Deviation is not same as expected Std Deviation\nStandard Dev = " + this.standardDeviation() + "Expected Standard Dev = " + expectedStandardDeviation);
        }
    }
}

