/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;

public class StringUtil {
    public static boolean compareStringLists(List<String> list1, List<String> list2) {
        return list1.equals(list2);
    }

    public static boolean compareStrings(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean compareStringsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static List<String> getActionReportMessageParts(ActionReport actionReport) {
        ArrayList<String> parts = new ArrayList<String>();
        for (ActionReport.MessagePart part : actionReport.getTopMessagePart().getChildren()) {
            parts.add(part.getMessage());
        }
        return parts;
    }

    public static String getCommaSeparatedStringList(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        if (strings != null) {
            boolean first = true;
            for (String str : strings) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(str);
                first = false;
            }
        }
        return sb.toString();
    }

    public static List<String> parseCommaSeparatedStringList(String stringList) {
        ArrayList<String> list = new ArrayList<String>();
        if (stringList != null) {
            StringTokenizer st = new StringTokenizer(stringList, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken().trim());
            }
        }
        return list;
    }

    public static boolean notEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public static String nonEmpty(String string) {
        return StringUtil.notEmpty(string) ? string : null;
    }

    public static String nonNull(String string) {
        return StringUtil.notEmpty(string) ? string : "";
    }
}

