/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.security.store.IdentityManagement;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.security.services.impl.JCEKSPasswordAliasStore;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="jks-based")
public class IdmService
implements PostConstruct,
IdentityManagement {
    private static final String PASSWORDFILE_OPTION_TO_ASMAIN = "-passwordfile";
    private static final String STDIN_OPTION_TO_ASMAIN = "-read-stdin";
    private static final String MP_PROPERTY = "AS_ADMIN_MASTERPASSWORD";
    private final Logger logger = Logger.getAnonymousLogger();
    @Inject
    private volatile StartupContext sc;
    @Inject
    private volatile ServerEnvironmentImpl env;
    private char[] masterPassword;

    public void postConstruct() {
        boolean success;
        boolean readStdin = this.sc.getArguments().containsKey(STDIN_OPTION_TO_ASMAIN);
        if (readStdin) {
            success = this.setFromStdin();
        } else {
            success = this.setFromMasterPasswordFile();
            if (!success) {
                success = this.setFromAsMainArguments();
            }
        }
        if (!success) {
            this.masterPassword = "changeit".toCharArray();
        }
    }

    public char[] getMasterPassword() {
        return Arrays.copyOf(this.masterPassword, this.masterPassword.length);
    }

    private boolean setFromMasterPasswordFile() {
        try {
            File mp = this.env.getMasterPasswordFile();
            if (!mp.isFile()) {
                this.logger.fine("The keystore file: " + mp.getAbsolutePath() + " does not exist, master password was not saved on disk during domain creation");
                return false;
            }
            JCEKSPasswordAliasStore masterPasswordAliasStore = JCEKSPasswordAliasStore.newInstance((String)mp.getAbsolutePath(), (char[])"master-password".toCharArray());
            char[] mpChars = masterPasswordAliasStore.get("master-password");
            if (mpChars == null) {
                return false;
            }
            this.masterPassword = mpChars;
            return true;
        }
        catch (Exception ex) {
            this.logger.fine("Error in master-password processing: " + ex.getMessage());
            return false;
        }
    }

    private boolean setFromAsMainArguments() {
        File pwf = null;
        try {
            String[] args = IdmService.getOriginalArguments(this.sc);
            int index = 0;
            for (String arg : args) {
                if (PASSWORDFILE_OPTION_TO_ASMAIN.equals(arg)) {
                    if (index == args.length - 1) {
                        this.logger.warning("NCLS-CORE-00077");
                        return false;
                    }
                    pwf = new File(args[index + 1]);
                    return this.readPasswordFile(pwf);
                }
                ++index;
            }
            return false;
        }
        catch (Exception ex) {
            String s = "Something wrong with given password file: ";
            String msg = pwf == null ? s : s + pwf.getAbsolutePath();
            this.logger.fine(msg);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readPasswordFile(File pwf) {
        Properties p = new Properties();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(pwf));
            p.load(br);
            if (p.getProperty(MP_PROPERTY) == null) {
                boolean bl = false;
                return bl;
            }
            this.masterPassword = p.getProperty(MP_PROPERTY).toCharArray();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.fine("Passwordfile: " + pwf.getAbsolutePath() + " (a simple property file) could not be processed, ignoring ...");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Exception decompiling
     */
    private boolean setFromStdin() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String[] getOriginalArguments(StartupContext context) {
        Properties args = context.getArguments();
        String s = args.getProperty("-startup-args");
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, ",,,", false);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }
}

