/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.model.Markup;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractRenderer
extends Renderer {
    protected static final String BUNDLE = "com.sun.webui.jsf.renderkit.html.Bundle";
    public static final String[] EVENTS_ATTRIBUTES = new String[]{"onClick", "onDblClick", "onChange", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp"};
    public static final String[] I18N_ATTRIBUTES = new String[]{"dir", "lang"};
    private static final String[] CORE_ATTRIBUTES = new String[]{"style", "title"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component instanceof EditableValueHolder) {
            this.setSubmittedValue(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderStart(context, component, writer);
            this.renderAttributes(context, component, writer);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            for (UIComponent kid : component.getChildren()) {
                RenderingUtilities.renderComponent(kid, context);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnd(context, component, writer);
        }
    }

    protected void addBooleanAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            boolean flag;
            Object value = attributes.get(name);
            if (value == null || !(flag = value instanceof String ? Boolean.parseBoolean((String)value) : Boolean.parseBoolean(value.toString()))) continue;
            writer.writeAttribute(name.toLowerCase(), (Object)name.toLowerCase(), name);
        }
    }

    protected void addCoreAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String styles) throws IOException {
        String id = component.getId();
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        RenderingUtilities.renderStyleClass(context, writer, component, styles);
        AbstractRenderer.addStringAttributes(context, component, writer, CORE_ATTRIBUTES);
    }

    protected void addIntegerAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            Integer ivalue;
            Object value = attributes.get(name);
            if (value == null || !(value instanceof Integer) || (ivalue = (Integer)value) == Integer.MIN_VALUE) continue;
            writer.writeAttribute(name.toLowerCase(), (Object)ivalue, name);
        }
    }

    protected static void addStringAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            Object value = attributes.get(name);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(name.toLowerCase(), (Object)((String)value), name);
                continue;
            }
            writer.writeAttribute(name.toLowerCase(), (Object)value.toString(), name);
        }
    }

    protected Application getApplication() {
        return this.getFacesContext().getApplication();
    }

    protected final Object getAsObject(FacesContext context, UIComponent component, String value) {
        Class clazz;
        ValueExpression vb;
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && (vb = component.getValueExpression("value")) != null && (clazz = vb.getType(context.getELContext())) != null) {
            converter = this.getApplication().createConverter(clazz);
        }
        if (converter != null) {
            return converter.getAsObject(context, component, value);
        }
        return value;
    }

    protected final String getAsString(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component == null) {
            return null;
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        Object value = ((ValueHolder)component).getValue();
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (value instanceof String) {
                return (String)value;
            }
            converter = this.getApplication().createConverter(value.getClass());
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        return value.toString();
    }

    protected final ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected final FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map parameters = context.getExternalContext().getRequestParameterMap();
        return parameters.get(clientId);
    }

    protected final boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.parseBoolean((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    protected final boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.parseBoolean((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderMarkup(FacesContext context, UIComponent component, ResponseWriter writer, Markup markup) throws IOException {
        writer.write(markup.getMarkup());
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void setSubmittedValue(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        component.getAttributes().put("submittedValue", this.getSubmittedValue(context, component));
    }
}

