/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConnectorsClassLoaderUtil {
    private static final Logger LOG = LogDomains.getLogger(ConnectorRuntime.class, (String)"jakarta.enterprise.resource.resourceadapter");
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ServerEnvironment env;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private Events events;
    private volatile boolean rarsInitializedInEmbeddedServerMode;

    public ConnectorClassFinder createRARClassLoader(String moduleDir, ClassLoader deploymentParent, String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ClassLoader parent = null;
        parent = deploymentParent == null ? this.clh.getCommonClassLoader() : deploymentParent;
        return this.createRARClassLoader(parent, moduleDir, moduleName, appLibs);
    }

    private DelegatingClassLoader.ClassFinder getLibrariesClassLoader(List<URI> appLibs) throws ConnectorRuntimeException {
        try {
            PrivilegedExceptionAction<DelegatingClassLoader.ClassFinder> action = () -> this.clh.getAppLibClassFinder(appLibs);
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw new ConnectorRuntimeException("Failed to create libraries classloader", e);
        }
    }

    private ConnectorClassFinder createRARClassLoader(ClassLoader parent, String moduleDir, String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ConnectorClassFinder cl = null;
        try {
            DelegatingClassLoader.ClassFinder librariesCL = this.getLibrariesClassLoader(appLibs);
            PrivilegedExceptionAction<ConnectorClassFinder> action = () -> {
                ConnectorClassFinder ccf = new ConnectorClassFinder(parent, moduleName, librariesCL);
                if (this.processEnv.getProcessType().isEmbedded()) {
                    this.events.register(event -> {
                        if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                            try {
                                ccf.close();
                            }
                            catch (IOException ioe) {
                                LOG.log(Level.WARNING, "Could not close the " + String.valueOf((Object)ccf), ioe);
                            }
                        }
                    });
                }
                return ccf;
            };
            cl = AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new ConnectorRuntimeException("Failed to create connector classloader", ex);
        }
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    private boolean extractRar(String rarName, String destination) {
        String rarFileName = rarName + ".rar";
        return ConnectorsUtil.extractRar(destination + rarFileName, rarFileName, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Collection<ConnectorClassFinder> getSystemRARClassLoaders() throws ConnectorRuntimeException {
        if (this.processEnv.getProcessType().isEmbedded() && !this.rarsInitializedInEmbeddedServerMode) {
            Class<ConnectorsClassLoaderUtil> clazz = ConnectorsClassLoaderUtil.class;
            // MONITORENTER : com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil.class
            if (!this.rarsInitializedInEmbeddedServerMode) {
                String installDir = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()) + File.separator;
                for (String jdbcRarName : ConnectorConstants.jdbcSystemRarNames) {
                    String rarPath = ConnectorsUtil.getSystemModuleLocation(jdbcRarName);
                    File rarDir = new File(rarPath);
                    if (rarDir.exists()) continue;
                    this.extractRar(jdbcRarName, installDir);
                }
                this.rarsInitializedInEmbeddedServerMode = true;
            }
            // MONITOREXIT : clazz
        }
        ArrayList<ConnectorClassFinder> classLoaders = new ArrayList<ConnectorClassFinder>();
        Iterator<String> iterator = ConnectorsUtil.getSystemRARs().iterator();
        while (iterator.hasNext()) {
            String rarName = iterator.next();
            String location = ConnectorsUtil.getSystemModuleLocation(rarName);
            List<Object> libraries = this.processEnv.getProcessType().isEmbedded() ? new ArrayList() : ConnectorsUtil.getInstalledLibrariesFromManifest(location, this.env);
            ConnectorClassFinder ccf = this.createRARClassLoader(location, null, rarName, libraries);
            classLoaders.add(ccf);
        }
        return classLoaders;
    }

    public ConnectorClassFinder getSystemRARClassLoader(String rarName) throws ConnectorRuntimeException {
        if (ConnectorsUtil.belongsToSystemRA(rarName)) {
            DelegatingClassLoader dch = this.clh.getConnectorClassLoader(null);
            for (DelegatingClassLoader.ClassFinder cf : dch.getDelegates()) {
                if (!(cf instanceof ConnectorClassFinder) || !rarName.equals(((ConnectorClassFinder)cf).getResourceAdapterName())) continue;
                return (ConnectorClassFinder)cf;
            }
        }
        throw new ConnectorRuntimeException("No Classloader found for RA [ " + rarName + " ]");
    }

    private void appendJars(File moduleDir, ASURLClassLoader cl) throws MalformedURLException {
        File[] list;
        if (moduleDir.isDirectory() && (list = moduleDir.listFiles()) != null) {
            for (File file : list) {
                if (file.getName().toUpperCase(Locale.getDefault()).endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }
}

