/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.taglibs.cache.CacheUtil;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.LogFacade;

public class FlushTag
extends TagSupport {
    private String _key;
    private int _scope = 4;
    private static final Logger _logger = LogFacade.getLogger();

    public int doStartTag() throws JspException {
        Cache cache = CacheUtil.getCache(this.pageContext, this._scope);
        if (this._key != null) {
            String key = CacheUtil.generateKey(this._key, this.pageContext);
            cache.remove((Object)key);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "AS-WEB-GLUE-00028", key);
            }
        } else {
            cache.clear();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "AS-WEB-GLUE-00029");
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this._key = null;
        this._scope = 4;
        return 6;
    }

    public void setKey(String key) {
        if (key != null && key.length() > 0) {
            this._key = key;
        }
    }

    public void setScope(String scope) {
        this._scope = CacheUtil.convertScope(scope);
    }
}

