/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.FactoryForEntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import jakarta.inject.Inject;
import jakarta.transaction.TransactionManager;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.javaee.services.JMSCFResourcePMProxy;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;

@Service
public class ComponentEnvManagerImpl
implements ComponentEnvManager {
    private static final Logger LOG = Logger.getLogger(ComponentEnvManagerImpl.class.getName());
    @Inject
    private ServiceLocator locator;
    @Inject
    GlassfishNamingManager namingManager;
    @Inject
    ComponentNamingUtil componentNamingUtil;
    @Inject
    private transient CallFlowAgent callFlowAgent;
    @Inject
    private transient TransactionManager transactionManager;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private NamingUtils namingUtils;
    @Inject
    private InvocationManager invocationManager;
    private final ConcurrentMap<String, RefCountJndiNameEnvironment> compId2Env = new ConcurrentHashMap<String, RefCountJndiNameEnvironment>();

    public void register(String componentId, JndiNameEnvironment env) {
        LOG.log(Level.FINEST, "register(componentId={0}, env.class={1})", new Object[]{componentId, env.getClass()});
        RefCountJndiNameEnvironment refCountJndiNameEnvironment = this.compId2Env.putIfAbsent(componentId, new RefCountJndiNameEnvironment(env));
        if (refCountJndiNameEnvironment != null) {
            refCountJndiNameEnvironment.refcnt.incrementAndGet();
        }
    }

    public void unregister(String componentId) {
        RefCountJndiNameEnvironment refCountJndiEnvironment = (RefCountJndiNameEnvironment)this.compId2Env.get(componentId);
        if (refCountJndiEnvironment != null && refCountJndiEnvironment.refcnt.decrementAndGet() == 0) {
            this.compId2Env.remove(componentId);
        }
    }

    @Override
    public JndiNameEnvironment getJndiNameEnvironment(String componentId) {
        LOG.log(Level.FINEST, "getJndiNameEnvironment(componentId={0})", componentId);
        if (componentId == null) {
            return null;
        }
        RefCountJndiNameEnvironment refCountJndiEnvironment = (RefCountJndiNameEnvironment)this.compId2Env.get(componentId);
        return refCountJndiEnvironment == null ? null : refCountJndiEnvironment.env;
    }

    @Override
    public JndiNameEnvironment getCurrentJndiNameEnvironment() {
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        return this.getJndiNameEnvironment(inv.componentId);
    }

    @Override
    public String bindToComponentNamespace(JndiNameEnvironment jndiEnvironment) throws NamingException {
        Application app;
        String componentEnvId = this.getComponentEnvId(jndiEnvironment);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(jndiEnvironment, ScopeType.COMPONENT, bindings);
        this.addJNDIBindings(jndiEnvironment, ScopeType.MODULE, bindings);
        if (!(jndiEnvironment instanceof ApplicationClientDescriptor)) {
            this.addJNDIBindings(jndiEnvironment, ScopeType.APP, bindings);
        }
        if (jndiEnvironment instanceof Application) {
            app = (Application)jndiEnvironment;
            for (Object bundleDescriptor : app.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                this.addJNDIBindings((JndiNameEnvironment)bundleDescriptor, ScopeType.APP, bindings);
            }
            this.namingManager.bindToAppNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)jndiEnvironment), bindings);
        } else {
            this.namingManager.bindToComponentNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)jndiEnvironment), DOLUtils.getModuleName((JndiNameEnvironment)jndiEnvironment), componentEnvId, DOLUtils.getTreatComponentAsModule((JndiNameEnvironment)jndiEnvironment), bindings);
            componentEnvId = this.getComponentEnvId(jndiEnvironment);
        }
        if (!(jndiEnvironment instanceof ApplicationClientDescriptor)) {
            ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(jndiEnvironment, ScopeType.GLOBAL, globalBindings);
            if (jndiEnvironment instanceof Application) {
                Application app2 = (Application)jndiEnvironment;
                for (JndiNameEnvironment bundleDescriptor : app2.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                    this.addJNDIBindings(bundleDescriptor, ScopeType.GLOBAL, globalBindings);
                }
            }
            for (JNDIBinding globalBinding : globalBindings) {
                this.namingManager.publishObject(globalBinding.getName(), globalBinding.getValue(), true);
            }
        }
        app = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)jndiEnvironment);
        if (!(jndiEnvironment instanceof ApplicationClientDescriptor) && !app.getBundleDescriptors(ApplicationClientDescriptor.class).isEmpty()) {
            for (JNDIBinding binding : bindings) {
                if (!this.dependencyAppliesToScope(binding.getName(), ScopeType.APP)) continue;
                this.namingManager.publishObject(this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), binding.getName()), binding.getValue(), true);
            }
        }
        if (componentEnvId != null) {
            this.register(componentEnvId, jndiEnvironment);
        }
        return componentEnvId;
    }

    @Override
    public void addToComponentNamespace(JndiNameEnvironment origEnv, Collection<EnvironmentProperty> envProps, Collection<ResourceReferenceDescriptor> resRefs) throws NamingException {
        String componentEnvId = this.getComponentEnvId(origEnv);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addEnvironmentProperties(ScopeType.COMPONENT, envProps, bindings);
        this.addResourceReferences(ScopeType.COMPONENT, resRefs, bindings);
        boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule((JndiNameEnvironment)origEnv);
        this.namingManager.bindToComponentNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)origEnv), DOLUtils.getModuleName((JndiNameEnvironment)origEnv), componentEnvId, treatComponentAsModule, bindings);
    }

    private String getResourceId(JndiNameEnvironment env, Descriptor desc) {
        if (this.dependencyAppliesToScope(desc, ScopeType.COMPONENT)) {
            return DOLUtils.getApplicationName((JndiNameEnvironment)env) + "/" + DOLUtils.getModuleName((JndiNameEnvironment)env) + "/" + this.getComponentEnvId(env);
        }
        if (this.dependencyAppliesToScope(desc, ScopeType.MODULE)) {
            return DOLUtils.getApplicationName((JndiNameEnvironment)env) + "/" + DOLUtils.getModuleName((JndiNameEnvironment)env);
        }
        if (this.dependencyAppliesToScope(desc, ScopeType.APP)) {
            return DOLUtils.getApplicationName((JndiNameEnvironment)env);
        }
        return "";
    }

    private void addAllDescriptorBindings(JndiNameEnvironment jndiEnv, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        HashSet allDescriptors = new HashSet();
        Set dataSourceDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.DSD);
        Set messagingConnectionFactoryDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.JMSCFDD);
        Set mailSessionDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.MSD);
        Set messagingDestinationDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.JMSDD);
        Set managedExecutorDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.MEDD);
        Set managedScheduledDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.MSEDD);
        Set managedThreadfactoryDefintions = jndiEnv.getResourceDescriptors(JavaEEResourceType.MTFDD);
        Set contextServiceDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.CSDD);
        if (jndiEnv instanceof ApplicationClientDescriptor) {
            LOG.fine("No support for connection-factory in client module.");
        } else {
            Set connectionFactoryDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.CFD);
            allDescriptors.addAll(connectionFactoryDefinitions);
        }
        if (jndiEnv instanceof ApplicationClientDescriptor) {
            LOG.fine("No support for administered-object in client module.");
        } else {
            Set administeredObjectDefinitions = jndiEnv.getResourceDescriptors(JavaEEResourceType.AODD);
            allDescriptors.addAll(administeredObjectDefinitions);
        }
        allDescriptors.addAll(dataSourceDefinitions);
        allDescriptors.addAll(messagingConnectionFactoryDefinitions);
        allDescriptors.addAll(mailSessionDefinitions);
        allDescriptors.addAll(messagingDestinationDefinitions);
        allDescriptors.addAll(managedExecutorDefinitions);
        allDescriptors.addAll(managedScheduledDefinitions);
        allDescriptors.addAll(managedThreadfactoryDefintions);
        allDescriptors.addAll(contextServiceDefinitions);
        for (ResourceDescriptor descriptor : allDescriptors) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope) || descriptor.getResourceType() == JavaEEResourceType.DSD && descriptor instanceof DataSourceDefinitionDescriptor && ((DataSourceDefinitionDescriptor)descriptor).isDeployed()) continue;
            descriptor.setResourceId(this.getResourceId(jndiEnv, (Descriptor)descriptor));
            CommonResourceProxy proxy = (CommonResourceProxy)this.locator.getService(CommonResourceProxy.class, new Annotation[0]);
            proxy.setDescriptor(descriptor);
            SimpleJndiName logicalJndiName = this.toLogicalJndiName((Descriptor)descriptor);
            CompEnvBinding envBinding = new CompEnvBinding(logicalJndiName, proxy);
            jndiBindings.add(envBinding);
            if (descriptor.getResourceType() != JavaEEResourceType.JMSCFDD) continue;
            CommonResourceProxy jmscfProxy = (CommonResourceProxy)this.locator.getService(JMSCFResourcePMProxy.class, new Annotation[0]);
            jmscfProxy.setDescriptor(descriptor);
            CompEnvBinding jmscfEnvBinding = new CompEnvBinding(ConnectorsUtil.getPMJndiName((SimpleJndiName)logicalJndiName), jmscfProxy);
            jndiBindings.add(jmscfEnvBinding);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        return ((ResourceManagerFactory)this.locator.getService(ResourceManagerFactory.class, new Annotation[0])).getResourceDeployer(resource);
    }

    @Override
    public void unbindFromComponentNamespace(JndiNameEnvironment JndiEnvironment) throws NamingException {
        this.undeployAllDescriptors(JndiEnvironment);
        ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(JndiEnvironment, ScopeType.GLOBAL, globalBindings);
        for (JNDIBinding globalBinding : globalBindings) {
            this.namingManager.unpublishObject(globalBinding.getName());
        }
        Application app = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)JndiEnvironment);
        Set appClientDescriptors = app.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor appClientDescriptor : appClientDescriptors) {
            this.undeployAllDescriptors((JndiNameEnvironment)appClientDescriptor);
        }
        if (!(JndiEnvironment instanceof ApplicationClientDescriptor) && app.getBundleDescriptors(ApplicationClientDescriptor.class).size() > 0) {
            ArrayList<JNDIBinding> appBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(JndiEnvironment, ScopeType.APP, appBindings);
            for (JNDIBinding appBinding : appBindings) {
                this.namingManager.unpublishObject(this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), appBinding.getName()));
            }
        }
        if (JndiEnvironment instanceof Application) {
            this.namingManager.unbindAppObjects(DOLUtils.getApplicationName((JndiNameEnvironment)JndiEnvironment));
        } else {
            String componentEnvId = this.getComponentEnvId(JndiEnvironment);
            this.namingManager.unbindComponentObjects(componentEnvId);
            this.unregister(componentEnvId);
        }
    }

    private void undeployAllDescriptors(JndiNameEnvironment env) {
        Set allDescriptors = env.getAllResourcesDescriptors(env.getClass());
        block7: for (ResourceDescriptor descriptor : allDescriptors) {
            switch (descriptor.getResourceType()) {
                case DSD: {
                    if (!(descriptor instanceof DataSourceDefinitionDescriptor)) break;
                    DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor = (DataSourceDefinitionDescriptor)descriptor;
                    if (!dataSourceDefinitionDescriptor.isDeployed() || !this.undepoyResource((Descriptor)dataSourceDefinitionDescriptor)) continue block7;
                    dataSourceDefinitionDescriptor.setDeployed(false);
                    break;
                }
                case MSD: {
                    if (!(descriptor instanceof MailSessionDescriptor)) break;
                    MailSessionDescriptor mailSessionDescriptor = (MailSessionDescriptor)descriptor;
                    if (!mailSessionDescriptor.isDeployed() || !this.undepoyResource((Descriptor)mailSessionDescriptor)) continue block7;
                    mailSessionDescriptor.setDeployed(false);
                    break;
                }
                case CFD: {
                    if (!(descriptor instanceof ConnectionFactoryDefinitionDescriptor)) break;
                    ConnectionFactoryDefinitionDescriptor connectionFactoryDefinitionDescriptor = (ConnectionFactoryDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)connectionFactoryDefinitionDescriptor);
                    break;
                }
                case JMSCFDD: {
                    if (!(descriptor instanceof JMSConnectionFactoryDefinitionDescriptor)) break;
                    JMSConnectionFactoryDefinitionDescriptor jmsConnectionFactoryDefinitionDescriptor = (JMSConnectionFactoryDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)jmsConnectionFactoryDefinitionDescriptor);
                    break;
                }
                case AODD: {
                    if (!(descriptor instanceof AdministeredObjectDefinitionDescriptor)) break;
                    AdministeredObjectDefinitionDescriptor administeredObjectDefinitionDescriptor = (AdministeredObjectDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)administeredObjectDefinitionDescriptor);
                    break;
                }
            }
        }
    }

    private boolean undepoyResource(Descriptor descriptor) {
        try {
            ResourceDeployer deployer = this.getResourceDeployer(descriptor);
            deployer.undeployResource((Object)descriptor);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to undeploy Descriptor [ " + descriptor.getName() + " ] ", e);
            return false;
        }
    }

    private void addEnvironmentProperties(ScopeType scope, Collection<EnvironmentProperty> envProps, Collection<JNDIBinding> jndiBindings) {
        for (EnvironmentProperty environmentProperty : envProps) {
            if (!this.dependencyAppliesToScope((Descriptor)environmentProperty, scope) || !environmentProperty.hasContent()) continue;
            SimpleJndiName name = this.toLogicalJndiName((Descriptor)environmentProperty);
            NamingObjectFactory value = environmentProperty.hasLookupName() ? this.namingUtils.createLazyNamingObjectFactory(name, environmentProperty.getLookupName(), true) : (environmentProperty.getMappedName().isEmpty() ? this.namingUtils.createSimpleNamingObjectFactory(name, environmentProperty.getValueObject(null)) : this.namingUtils.createLazyNamingObjectFactory(name, environmentProperty.getMappedName(), true));
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addResourceReferences(ScopeType scope, Collection<ResourceReferenceDescriptor> resRefs, Collection<JNDIBinding> jndiBindings) {
        for (ResourceReferenceDescriptor resourceRef : resRefs) {
            if (!this.dependencyAppliesToScope((Descriptor)resourceRef, scope)) continue;
            resourceRef.checkType();
            SimpleJndiName name = this.toLogicalJndiName((Descriptor)resourceRef);
            SimpleJndiName physicalJndiName = resourceRef.getJndiName();
            Object value = null;
            if (resourceRef.isURLResource()) {
                if (physicalJndiName.isJavaGlobal() || physicalJndiName.isJavaApp() || physicalJndiName.isJavaModule() || physicalJndiName.isJavaComponent()) {
                    value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
                } else {
                    try {
                        value = this.namingUtils.createCloningNamingObjectFactory(name, this.namingUtils.createSimpleNamingObjectFactory(name, (Object)new URL(physicalJndiName.toString())));
                    }
                    catch (MalformedURLException e) {
                        value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
                    }
                }
            } else if (resourceRef.isORB()) {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            } else if (resourceRef.isWebServiceContext()) {
                WebServiceReferenceManager wsRefMgr = (WebServiceReferenceManager)this.locator.getService(WebServiceReferenceManager.class, new Annotation[0]);
                if (wsRefMgr != null) {
                    value = wsRefMgr.getWSContextObject();
                } else {
                    LOG.log(Level.SEVERE, "Cannot find the following class to proceed with @Resource WebServiceContext" + String.valueOf(wsRefMgr) + "Please confirm if webservices module is installed ");
                }
            } else {
                value = resourceRef.isJDBCResource() || resourceRef.isJMSConnectionFactory() || resourceRef.isMailResource() || resourceRef.isResourceConnectionFactory() ? this.namingUtils.createLazyInitializationNamingObjectFactory(name, physicalJndiName, false) : this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            }
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addJNDIBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        Object value;
        SimpleJndiName name;
        this.addEnvironmentProperties(scope, env.getEnvironmentProperties(), jndiBindings);
        for (ResourceEnvReferenceDescriptor descriptor : env.getResourceEnvReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            descriptor.checkType();
            jndiBindings.add(this.getCompEnvBinding(descriptor));
        }
        this.addAllDescriptorBindings(env, scope, jndiBindings);
        for (ResourceEnvReferenceDescriptor descriptor : env.getEjbReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            name = this.toLogicalJndiName((Descriptor)descriptor);
            EjbReferenceProxy proxy = new EjbReferenceProxy((EjbReferenceDescriptor)descriptor);
            jndiBindings.add(new CompEnvBinding(name, proxy));
        }
        for (ResourceEnvReferenceDescriptor descriptor : env.getMessageDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding((MessageDestinationReferenceDescriptor)descriptor));
        }
        this.addResourceReferences(scope, env.getResourceReferenceDescriptors(), jndiBindings);
        for (ResourceEnvReferenceDescriptor descriptor : env.getEntityManagerFactoryReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            name = this.toLogicalJndiName((Descriptor)descriptor);
            value = new FactoryForEntityManagerFactoryWrapper(descriptor.getUnitName(), this.invocationManager, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (ResourceEnvReferenceDescriptor descriptor : env.getServiceReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            if (descriptor.getMappedName() != null) {
                descriptor.setName(descriptor.getMappedName().toString());
            }
            name = this.toLogicalJndiName((Descriptor)descriptor);
            value = new WebServiceRefProxy((ServiceReferenceDescriptor)descriptor);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (ResourceEnvReferenceDescriptor descriptor : env.getEntityManagerReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope)) continue;
            name = this.toLogicalJndiName((Descriptor)descriptor);
            value = new FactoryForEntityManagerWrapper((EntityManagerReferenceDescriptor)descriptor, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private CompEnvBinding getCompEnvBinding(final ResourceEnvReferenceDescriptor next) {
        Object value;
        final SimpleJndiName name = this.toLogicalJndiName((Descriptor)next);
        if (next.isEJBContext()) {
            value = new EjbContextProxy(next.getRefType());
        } else if (next.isValidator()) {
            value = new ValidatorProxy(LOG);
        } else if (next.isValidatorFactory()) {
            value = new ValidatorFactoryProxy(LOG);
        } else if (next.isCDIBeanManager()) {
            value = this.namingUtils.createLazyNamingObjectFactory(name, new SimpleJndiName("java:comp/BeanManager"), false);
        } else if (next.isManagedBean()) {
            ManagedBeanDescriptor managedBeanDesc = next.getManagedBeanDescriptor();
            value = this.processEnvironment.getProcessType().isServer() ? this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false) : this.namingUtils.createLazyNamingObjectFactory(name, managedBeanDesc.getAppJndiName(), false);
        } else {
            value = new NamingObjectFactory(){
                NamingObjectFactory delegate;
                {
                    this.delegate = ComponentEnvManagerImpl.this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false);
                }

                public boolean isCreateResultCacheable() {
                    return false;
                }

                public <T> T create(Context ic) throws NamingException {
                    return (T)this.delegate.create(ic);
                }
            };
        }
        return new CompEnvBinding(name, value);
    }

    private CompEnvBinding getCompEnvBinding(MessageDestinationReferenceDescriptor messageDestinationRef) {
        SimpleJndiName name = this.toLogicalJndiName((Descriptor)messageDestinationRef);
        SimpleJndiName physicalJndiName = messageDestinationRef.isLinkedToMessageDestination() ? messageDestinationRef.getMessageDestination().getJndiName() : messageDestinationRef.getJndiName();
        return new CompEnvBinding(name, this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true));
    }

    private boolean dependencyAppliesToScope(Descriptor descriptor, ScopeType scope) {
        return this.dependencyAppliesToScope(new SimpleJndiName(descriptor.getName()), scope);
    }

    private boolean dependencyAppliesToScope(SimpleJndiName name, ScopeType scope) {
        LOG.log(Level.FINEST, "dependencyAppliesToScope(name={0}, scope={1})", new Object[]{name, scope});
        switch (scope) {
            case COMPONENT: {
                return name.isJavaComponent() || !name.hasJavaPrefix();
            }
            case MODULE: {
                return name.isJavaModule();
            }
            case APP: {
                return name.isJavaApp();
            }
            case GLOBAL: {
                return name.isJavaGlobal();
            }
        }
        return false;
    }

    private SimpleJndiName toLogicalJndiName(Descriptor descriptor) {
        String rawName = descriptor.getName();
        LOG.log(Level.FINEST, "toLogicalJndiName(descriptor); rawName={0}", rawName);
        return new SimpleJndiName((String)(rawName.startsWith("java:") ? rawName : "java:comp/env/" + rawName));
    }

    @Override
    public String getComponentEnvId(JndiNameEnvironment env) {
        String componentEnvId = DOLUtils.getComponentEnvId((JndiNameEnvironment)env);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ApplicationName={0}, ComponentId={1}", new Object[]{DOLUtils.getApplicationName((JndiNameEnvironment)env), componentEnvId});
        }
        return componentEnvId;
    }

    @Override
    public ApplicationEnvironment getCurrentApplicationEnvironment() {
        return this.invocationManager.peekAppEnvironment();
    }

    private static class RefCountJndiNameEnvironment {
        public JndiNameEnvironment env;
        public AtomicInteger refcnt;

        public RefCountJndiNameEnvironment(JndiNameEnvironment env) {
            this.env = env;
            this.refcnt = new AtomicInteger(1);
        }
    }

    private static enum ScopeType {
        COMPONENT,
        MODULE,
        APP,
        GLOBAL;

    }

    private static class CompEnvBinding
    implements JNDIBinding {
        private final SimpleJndiName name;
        private final Object value;

        CompEnvBinding(SimpleJndiName name, Object value) {
            this.name = name;
            this.value = value;
        }

        public SimpleJndiName getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + String.valueOf(this.name) + ", value=" + String.valueOf(this.value) + "]";
        }
    }

    private class EjbReferenceProxy
    implements NamingObjectProxy {
        private final EjbReferenceDescriptor ejbRef;
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private volatile Object cachedResult;
        private Boolean cacheable;

        EjbReferenceProxy(EjbReferenceDescriptor ejbRef) {
            this.ejbRef = ejbRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                EjbReferenceProxy ejbReferenceProxy = this;
                synchronized (ejbReferenceProxy) {
                    if (this.ejbRefMgr == null) {
                        this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.locator.getService(EjbNamingReferenceManager.class, new Annotation[0]);
                        this.cacheable = this.ejbRefMgr.isEjbReferenceCacheable(this.ejbRef);
                    }
                }
            }
            if (this.ejbRefMgr != null) {
                result = this.cacheable != null && this.cacheable.booleanValue() ? (this.cachedResult == null ? (this.cachedResult = this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx)) : this.cachedResult) : this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve ejb reference " + this.ejbRef.getName() + " : " + String.valueOf(this.ejbRef));
            }
            return (T)result;
        }
    }

    private class WebServiceRefProxy
    implements NamingObjectProxy {
        private WebServiceReferenceManager webServiceRefManager;
        private final ServiceReferenceDescriptor serviceRef;

        WebServiceRefProxy(ServiceReferenceDescriptor servRef) {
            this.serviceRef = servRef;
        }

        public <T> T create(Context ctx) throws NamingException {
            Object result;
            this.webServiceRefManager = (WebServiceReferenceManager)ComponentEnvManagerImpl.this.locator.getService(WebServiceReferenceManager.class, new Annotation[0]);
            if (this.webServiceRefManager == null) {
                LOG.log(Level.SEVERE, "Cannot find the WebServiceReferenceManager to proceed with @WebServiceRef. Please check if webservices module is installed ");
                result = null;
            } else {
                result = this.webServiceRefManager.resolveWSReference(this.serviceRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve webservice context of type " + this.serviceRef.getName());
            }
            return (T)result;
        }
    }

    private class FactoryForEntityManagerWrapper
    implements NamingObjectProxy {
        private final EntityManagerReferenceDescriptor entityManagerRefDescriptor;
        private final ComponentEnvManager componentEnvManager;

        FactoryForEntityManagerWrapper(EntityManagerReferenceDescriptor refDesc, ComponentEnvManager compEnvMgr) {
            this.entityManagerRefDescriptor = refDesc;
            this.componentEnvManager = compEnvMgr;
        }

        public Object create(Context ctx) {
            EntityManagerWrapper emWrapper = new EntityManagerWrapper(ComponentEnvManagerImpl.this.transactionManager, ComponentEnvManagerImpl.this.invocationManager, this.componentEnvManager, ComponentEnvManagerImpl.this.callFlowAgent);
            emWrapper.initializeEMWrapper(this.entityManagerRefDescriptor.getUnitName(), this.entityManagerRefDescriptor.getPersistenceContextType(), this.entityManagerRefDescriptor.getSynchronizationType(), this.entityManagerRefDescriptor.getProperties());
            return emWrapper;
        }
    }

    private class EjbContextProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbNamingRefManager;
        private final String contextType;

        EjbContextProxy(String contextType) {
            this.contextType = contextType;
        }

        public <T> T create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbNamingRefManager == null) {
                this.ejbNamingRefManager = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.locator.getService(EjbNamingReferenceManager.class, new Annotation[0]);
            }
            if (this.ejbNamingRefManager != null) {
                result = this.ejbNamingRefManager.getEJBContextObject(this.contextType);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve EJB context of type " + this.contextType);
            }
            return (T)result;
        }
    }

    private static class ValidatorProxy
    implements NamingObjectProxy {
        private volatile ValidatorFactory validatorFactory;
        private volatile Validator validator;
        private final Logger logger;

        private ValidatorProxy(Logger logger) {
            this.logger = logger;
        }

        public Validator create(Context ctx) throws NamingException {
            String exceptionMessage = "Can not obtain reference to Validator instance ";
            if (this.validator == null) {
                if (this.validatorFactory == null) {
                    ValidatorFactoryProxy factoryProxy = new ValidatorFactoryProxy(this.logger);
                    this.validatorFactory = factoryProxy.create(ctx);
                }
                if (this.validatorFactory != null) {
                    ValidatorContext validatorContext = this.validatorFactory.usingContext();
                    this.validator = validatorContext.getValidator();
                }
            }
            if (this.validator == null) {
                throw new NameNotFoundException(exceptionMessage);
            }
            return this.validator;
        }
    }

    private static class ValidatorFactoryProxy
    implements NamingObjectProxy {
        private static final String nameForValidatorFactory = "java:comp/ValidatorFactory";
        private volatile ValidatorFactory validatorFactory;
        private final Logger _logger;

        private ValidatorFactoryProxy(Logger logger) {
            this._logger = logger;
        }

        public ValidatorFactory create(Context ctx) throws NamingException {
            if (this.validatorFactory == null) {
                try {
                    this.validatorFactory = Validation.buildDefaultValidatorFactory();
                }
                catch (ValidationException e) {
                    this._logger.log(Level.WARNING, "Unable to lookup {0}, or build a default Bean Validator Factory: {1}", new Object[]{nameForValidatorFactory, e});
                    NameNotFoundException ne = new NameNotFoundException();
                    ne.initCause(e);
                    throw ne;
                }
            }
            return this.validatorFactory;
        }
    }
}

