/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.memory.Buffers;

public class HttpContent
extends HttpPacket
implements Appendable<HttpContent> {
    private static final ThreadCache.CachedTypeIndex<HttpContent> CACHE_IDX = ThreadCache.obtainIndex(HttpContent.class, (int)16);
    protected boolean isLast;
    protected Buffer content = Buffers.EMPTY_BUFFER;
    protected HttpHeader httpHeader;

    public static boolean isContent(HttpPacket httpPacket) {
        return httpPacket instanceof HttpContent;
    }

    public static boolean isBroken(HttpContent httpContent) {
        return httpContent instanceof HttpBrokenContent;
    }

    public static HttpContent create() {
        return HttpContent.create(null);
    }

    public static HttpContent create(HttpHeader httpHeader) {
        return HttpContent.create(httpHeader, false);
    }

    public static HttpContent create(HttpHeader httpHeader, boolean isLast) {
        return HttpContent.create(httpHeader, isLast, Buffers.EMPTY_BUFFER);
    }

    public static HttpContent create(HttpHeader httpHeader, boolean isLast, Buffer content) {
        content = content != null ? content : Buffers.EMPTY_BUFFER;
        HttpContent httpContent = (HttpContent)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpContent != null) {
            httpContent.httpHeader = httpHeader;
            httpContent.isLast = isLast;
            httpContent.content = content;
            return httpContent;
        }
        return new HttpContent(httpHeader, isLast, content);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return new Builder().httpHeader(httpHeader);
    }

    protected HttpContent() {
        this(null);
    }

    protected HttpContent(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    protected HttpContent(HttpHeader httpHeader, boolean isLast, Buffer content) {
        this.httpHeader = httpHeader;
        this.isLast = isLast;
        this.content = content;
    }

    public Buffer getContent() {
        return this.content;
    }

    protected final void setContent(Buffer content) {
        this.content = content;
    }

    @Override
    public final HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    @Override
    public final boolean isHeader() {
        return false;
    }

    public HttpContent append(HttpContent element) {
        if (this.isLast) {
            throw new IllegalStateException("Can not append to a last chunk");
        }
        if (HttpContent.isBroken(element)) {
            return element;
        }
        Buffer content2 = element.getContent();
        if (content2 != null && content2.hasRemaining()) {
            this.content = Buffers.appendBuffers(null, (Buffer)this.content, (Buffer)content2);
        }
        if (element.isLast()) {
            element.setContent(this.content);
            return element;
        }
        return this;
    }

    protected void reset() {
        this.isLast = false;
        this.content = Buffers.EMPTY_BUFFER;
        this.httpHeader = null;
    }

    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static class Builder<T extends Builder> {
        protected boolean last;
        protected Buffer content;
        protected HttpHeader httpHeader;

        protected Builder() {
        }

        public final T httpHeader(HttpHeader httpHeader) {
            this.httpHeader = httpHeader;
            return (T)this;
        }

        public final T last(boolean last) {
            this.last = last;
            return (T)this;
        }

        public final T content(Buffer content) {
            this.content = content;
            return (T)this;
        }

        public HttpContent build() {
            if (this.httpHeader == null) {
                throw new IllegalStateException("No HttpHeader specified to associate with this HttpContent.");
            }
            HttpContent httpContent = this.create();
            httpContent.httpHeader = this.httpHeader;
            httpContent.setLast(this.last);
            if (this.content != null) {
                httpContent.setContent(this.content);
            }
            return httpContent;
        }

        public void reset() {
            this.last = false;
            this.content = null;
            this.httpHeader = null;
        }

        protected HttpContent create() {
            return HttpContent.create();
        }
    }
}

