/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.annotation;

import org.eclipse.eclemma.internal.ui.annotation.CoverageAnnotationModel;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTracker {
    private final IWorkbench workbench;
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener(EditorTracker.this.partListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener(EditorTracker.this.partListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partOpened(IWorkbenchPartReference partref) {
            EditorTracker.this.annotateEditor(partref);
        }

        public void partActivated(IWorkbenchPartReference partref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partref) {
        }

        public void partVisible(IWorkbenchPartReference partref) {
        }

        public void partInputChanged(IWorkbenchPartReference partref) {
        }

        public void partClosed(IWorkbenchPartReference partref) {
        }

        public void partDeactivated(IWorkbenchPartReference partref) {
        }

        public void partHidden(IWorkbenchPartReference partref) {
        }
    };

    public EditorTracker(IWorkbench workbench) {
        this.workbench = workbench;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            w.getPartService().addPartListener(this.partListener);
            ++n2;
        }
        workbench.addWindowListener(this.windowListener);
        this.annotateAllEditors();
    }

    public void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            w.getPartService().removePartListener(this.partListener);
            ++n2;
        }
    }

    private void annotateAllEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage p = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = p.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference e = iEditorReferenceArray[n6];
                    this.annotateEditor((IWorkbenchPartReference)e);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void annotateEditor(IWorkbenchPartReference partref) {
        IWorkbenchPart part = partref.getPart(false);
        if (part instanceof ITextEditor) {
            CoverageAnnotationModel.attach((ITextEditor)part);
        }
    }
}

