/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class FileCharsetDetector
extends AbstractLogEnabled {
    private String charset = null;
    private boolean found = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCharsetDetector(File detectedFile) throws FileNotFoundException, IOException {
        nsDetector det = new nsDetector(0);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                FileCharsetDetector.this.charset = charset;
                FileCharsetDetector.this.found = true;
            }
        });
        FileInputStream fileInputStream = new FileInputStream(detectedFile);
        BufferedInputStream imp = new BufferedInputStream(fileInputStream);
        try {
            String[] prob;
            int len;
            byte[] buf = new byte[1024];
            boolean done = false;
            boolean isAscii = true;
            while ((len = imp.read(buf, 0, buf.length)) != -1) {
                if (isAscii) {
                    isAscii = det.isAscii(buf, len);
                }
                if (isAscii || done) continue;
                this.found = done = det.DoIt(buf, len, false);
            }
            det.DataEnd();
            if (!this.isFound() && (prob = det.getProbableCharsets()).length > 0) {
                this.charset = prob[0];
            }
            if (isAscii) {
                this.charset = "ASCII";
            }
        }
        finally {
            imp.close();
            fileInputStream.close();
        }
    }

    public FileCharsetDetector(InputStream detectedStream) throws FileNotFoundException, IOException {
        String[] prob;
        int len;
        nsDetector det = new nsDetector(0);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                FileCharsetDetector.this.charset = charset;
                FileCharsetDetector.this.found = true;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(detectedStream);
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            this.found = done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (!this.isFound() && (prob = det.getProbableCharsets()).length > 0) {
            this.charset = prob[0];
        }
        if (isAscii) {
            this.charset = "ASCII";
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isFound() {
        return this.found;
    }
}

