/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.ConsoleListeners;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class PrepareForReplaceVisitor
implements ICVSResourceVisitor {
    private IProgressMonitor monitor;
    private int depth;
    private CVSTag tag;
    private Set deletedFiles;
    private Session session;

    public PrepareForReplaceVisitor(Session session, CVSTag tag) {
        this.tag = tag;
        this.session = session;
    }

    @Override
    public void visitFile(ICVSFile file) throws CVSException {
        block13: {
            byte[] syncBytes = file.getSyncBytes();
            if (syncBytes == null) {
                if (CVSProviderPlugin.getPlugin().isReplaceUnmanaged()) {
                    file.delete();
                    this.deletedFiles.add(file);
                }
            } else if (ResourceSyncInfo.isAddition(syncBytes)) {
                file.delete();
                this.deletedFiles.add(file);
                file.unmanage(null);
            } else if (ResourceSyncInfo.isDeletion(syncBytes)) {
                if (!this.shouldDeleteModifications(file)) {
                    IFile res = (IFile)file.getIResource();
                    try {
                        IFileState[] states = res.getHistory(null);
                        if (states.length > 0) {
                            this.restoreParentDirectory(file);
                            res.create(states[0].getContents(), true, null);
                            break block13;
                        }
                        Status status = new Status(4, "org.eclipse.team.cvs.core", CVSMessages.PrepareForReplaceVisitor_DeletedFileWithoutHistoryCannotBeRestoredWhileRevertToBase);
                        CVSProviderPlugin.log((IStatus)status);
                        ConsoleListeners.getInstance().errorLineReceived(this.session, NLS.bind((String)CVSMessages.PrepareForReplaceVisitor_FileCannotBeReplacedWithBase, (Object)res.getName()), (IStatus)status);
                    }
                    catch (CoreException e) {
                        CVSProviderPlugin.log(e);
                    }
                } else {
                    file.unmanage(null);
                }
            } else if (file.isModified(null) && this.shouldDeleteModifications(file)) {
                file.delete();
                this.deletedFiles.add(file);
                file.unmanage(null);
            }
        }
        this.monitor.worked(1);
    }

    private void restoreParentDirectory(ICVSFile file) throws CVSException {
        ArrayList<ICVSFolder> parents = new ArrayList<ICVSFolder>();
        ICVSFolder parent = file.getParent();
        while (!parent.getIResource().exists()) {
            parents.add(parent);
            parent = parent.getParent();
        }
        int i = parents.size() - 1;
        while (i > -1) {
            ((ICVSFolder)parents.get(i)).mkdir();
            --i;
        }
    }

    private boolean shouldDeleteModifications(ICVSFile file) {
        return this.tag == null && !this.isStickyRevision(file) || this.tag != null && !this.tag.getName().equals("BASE");
    }

    private boolean isStickyRevision(ICVSFile file) {
        try {
            CVSTag tag;
            ResourceSyncInfo info = file.getSyncInfo();
            if (info != null && (tag = info.getTag()) != null) {
                return tag.getName().equals(info.getRevision());
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    @Override
    public void visitFolder(ICVSFolder folder) throws CVSException {
        if (!folder.isCVSFolder()) {
            if (CVSProviderPlugin.getPlugin().isReplaceUnmanaged()) {
                folder.acceptChildren(this);
                folder.delete();
            }
        } else {
            int i;
            if (this.depth == 2) {
                folder.acceptChildren(this);
            } else if (this.depth == 1) {
                ICVSResource[] files = folder.members(1);
                i = 0;
                while (i < files.length) {
                    files[i].accept(this);
                    ++i;
                }
            }
            ICVSResource[] ignoredFiles = folder.members(5);
            i = 0;
            while (i < ignoredFiles.length) {
                ICVSResource cvsResource = ignoredFiles[i];
                if (cvsResource.getName().startsWith(".#")) {
                    cvsResource.delete();
                }
                ++i;
            }
        }
        this.monitor.worked(1);
    }

    public void visitResources(IProject project, ICVSResource[] resources, String oneArgMessage, int depth, IProgressMonitor pm) throws CVSException {
        this.depth = depth;
        this.deletedFiles = new HashSet();
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).run(pm1 -> {
            this.monitor = Policy.infiniteSubMonitorFor(pm1, 100);
            this.monitor.beginTask(null, 512);
            int i = 0;
            while (i < resources.length) {
                if (oneArgMessage != null) {
                    this.monitor.subTask(NLS.bind((String)oneArgMessage, (Object[])new String[]{resources[i].getIResource().getFullPath().toString()}));
                }
                resources[i].accept(this);
                ++i;
            }
            this.monitor.done();
        }, pm);
    }

    public Set getDeletedFiles() {
        return Collections.unmodifiableSet(this.deletedFiles);
    }
}

