/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

public class XMLWriter
extends PrintWriter {
    protected int tab = 0;
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public XMLWriter(OutputStream output) {
        super(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        this.println(XML_VERSION);
    }

    public void endTag(String name) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null);
    }

    public void printSimpleTag(String name, Object value) {
        if (value != null) {
            this.printTag(name, null, true, false);
            this.print(XMLWriter.getEscaped(String.valueOf(value)));
            this.printTag(String.valueOf('/') + name, null, false, true);
        }
    }

    public void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print('\t');
            ++i;
        }
    }

    private void printTag(String name, HashMap parameters) {
        this.printTag(name, parameters, true, true);
    }

    private void printTag(String name, HashMap parameters, boolean tab, boolean newLine) {
        this.printTag(name, parameters, tab, newLine, false);
    }

    private void printTag(String name, HashMap parameters, boolean tab, boolean newLine, boolean end) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        if (parameters != null) {
            Enumeration e = Collections.enumeration(parameters.keySet());
            while (e.hasMoreElements()) {
                sb.append(" ");
                String key = (String)e.nextElement();
                sb.append(key);
                sb.append("=\"");
                sb.append(XMLWriter.getEscaped(String.valueOf(parameters.get(key))));
                sb.append("\"");
            }
        }
        if (end) {
            sb.append('/');
        }
        sb.append(">");
        if (tab) {
            this.printTabulation();
        }
        if (newLine) {
            this.println(sb.toString());
        } else {
            this.print(sb.toString());
        }
    }

    public void startTag(String name, HashMap parameters) {
        this.startTag(name, parameters, true);
    }

    public void startTag(String name, HashMap parameters, boolean newLine) {
        this.printTag(name, parameters, true, newLine);
        ++this.tab;
    }

    public void startAndEndTag(String name, HashMap parameters, boolean newLine) {
        this.printTag(name, parameters, true, true, true);
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    public static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

