/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExportIdsHandler {
    public static final String DEFAULT_APPMODELID_CLASSNAME = "AppModelId";

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Translation Messages messages, IModelResource resource, IResourcePool pool, IProject project) {
        ExportIdDialog dialog = new ExportIdDialog(shell, messages, resource.getRoot(), pool, project);
        dialog.open();
    }

    private static String findIdFieldKey(MApplicationElement object) {
        StringBuilder sb = new StringBuilder();
        sb.append(((EObject)object).eClass().getName());
        sb.append("_");
        sb.append(ExportIdsHandler.replaceInvalidChar(object.getElementId()));
        return sb.toString().toUpperCase();
    }

    private static String replaceInvalidChar(String elementId) {
        return elementId.replaceAll("[^A-Za-z0-9]", "_");
    }

    private static class Entry
    implements Comparable<Entry> {
        private MApplicationElement object;
        private String idFieldKey;
        private String elementId;

        public Entry(MApplicationElement object, String idFieldKey, String elementId) {
            this.object = object;
            this.idFieldKey = idFieldKey;
            this.elementId = elementId;
        }

        @Override
        public int compareTo(Entry o) {
            return this.idFieldKey.compareTo(o.idFieldKey);
        }
    }

    static class ExportIdDialog
    extends TitleAreaDialog {
        private Messages messages;
        private IObservableList<?> list;
        private IResourcePool pool;
        private JavaClass clazz;
        private CheckboxTableViewer viewer;
        private Text textClassName;

        public ExportIdDialog(Shell parentShell, Messages messages, IObservableList<?> list, IResourcePool pool, IProject project) {
            super(parentShell);
            this.messages = messages;
            this.list = list;
            this.pool = pool;
            this.clazz = new JavaClass();
            if (JavaProject.hasJavaNature((IProject)project)) {
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                        if (iPackageFragmentRoot.getKind() == 1) {
                            this.clazz.packageFragment = iPackageFragmentRoot.createPackageFragment(project.getName(), false, (IProgressMonitor)new NullProgressMonitor());
                            break;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else {
                this.setErrorMessage(messages.ExportIdsHandler_Dialog_SelectProject);
                this.getButton(0).setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.messages.ExportIdsHandler_Dialog_ShellTitle);
            this.setTitle(this.messages.ExportIdsHandler_Dialog_DialogTitle);
            this.setMessage(this.messages.ExportIdsHandler_Dialog_DialogMessage);
            this.setTitleImage(this.pool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.wizban.extstr_wiz"));
            Composite content = (Composite)super.createDialogArea(parent);
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite container = new Composite(content, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gl = new GridLayout(2, false);
            gl.numColumns = 2;
            gl.marginBottom = 4;
            container.setLayout((Layout)gl);
            Label lblTargetClass = new Label(container, 0);
            lblTargetClass.setText(this.messages.ExportIdsHandler_Dialog_TargetClassName);
            this.textClassName = new Text(container, 2048);
            this.textClassName.setText(ExportIdsHandler.DEFAULT_APPMODELID_CLASSNAME);
            GridData gdcn = new GridData();
            gdcn.horizontalAlignment = 4;
            gdcn.grabExcessHorizontalSpace = true;
            this.textClassName.setLayoutData((Object)gdcn);
            Table t = new Table(container, 68384);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = t.getItemHeight() * 18;
            container.setLayoutData((Object)gd);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.horizontalSpan = 2;
            gd2.heightHint = t.getItemHeight() * 17;
            t.setHeaderVisible(true);
            t.setLinesVisible(true);
            t.setLayoutData((Object)gd2);
            this.viewer = new CheckboxTableViewer(t);
            TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return "";
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExportIdsHandler_Dialog_ElementName);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return ((EObject)e.object).eClass().getName();
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExportIdsHandler_Dialog_Key);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.idFieldKey;
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExportIdsHandler_Dialog_Id_Value);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.elementId;
                }
            });
            int i = 1;
            while (i < this.viewer.getTable().getColumnCount()) {
                TableColumn c = this.viewer.getTable().getColumn(i);
                c.pack();
                if (c.getWidth() < 120) {
                    c.setWidth(120);
                }
                ++i;
            }
            Label l = new Label(parent, 258);
            l.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
            ArrayList<Entry> entries = new ArrayList<Entry>();
            TreeIterator it = EcoreUtil.getAllContents(this.list);
            while (it.hasNext()) {
                MApplicationElement o;
                Object next = it.next();
                if (!(next instanceof MApplicationElement) || (o = (MApplicationElement)next).getElementId() == null || o.getElementId().length() <= 1) continue;
                String idFieldKey = ExportIdsHandler.findIdFieldKey(o);
                entries.add(new Entry(o, idFieldKey, o.getElementId()));
            }
            Collections.sort(entries);
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setInput(entries);
            this.viewer.setAllChecked(true);
            int i2 = 1;
            while (i2 < this.viewer.getTable().getColumnCount()) {
                TableColumn c = this.viewer.getTable().getColumn(i2);
                c.pack();
                if (c.getWidth() < 120) {
                    c.setWidth(120);
                }
                ++i2;
            }
            return container;
        }

        protected void okPressed() {
            this.clazz.name = this.textClassName.getText();
            Object[] els = this.viewer.getCheckedElements();
            if (els.length > 0) {
                try {
                    String content = this.compileFileContent(els);
                    IPackageFragment fragment = this.clazz.packageFragment;
                    String cuName = String.valueOf(this.clazz.name) + ".java";
                    ICompilationUnit unit = fragment.getCompilationUnit(cuName);
                    IResource resource = unit.getResource();
                    IFile file = (IFile)resource;
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (ByteArrayInputStream stream = new ByteArrayInputStream(content.toString().getBytes());){
                        if (file.exists()) {
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        this.createParent(file.getParent());
                        file.create((InputStream)stream, 2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    super.okPressed();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private String compileFileContent(Object[] els) {
            StringBuilder b = new StringBuilder();
            b.append("package " + this.clazz.packageFragment.getElementName() + ";" + System.getProperty("line.separator"));
            b.append(System.getProperty("line.separator"));
            b.append("public class " + this.clazz.name + " {" + System.getProperty("line.separator"));
            Object[] objectArray = els;
            int n = els.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Entry e = (Entry)o;
                b.append("\tpublic static final String " + e.idFieldKey + " = \"" + e.elementId + "\";" + System.getProperty("line.separator"));
                ++n2;
            }
            b.append("}");
            return b.toString();
        }

        private void createParent(IContainer container) throws CoreException {
            if (!container.exists()) {
                this.createParent(container.getParent());
                if (container instanceof IFolder) {
                    IFolder f = (IFolder)container;
                    f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    private static class JavaClass {
        private IPackageFragment packageFragment;
        private String name;

        private JavaClass() {
        }
    }
}

