/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.factories;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;

public class GitFlowAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (Repository.class.equals(adapterType)) {
            Repository repository = null;
            if (adaptableObject instanceof IResource) {
                IResource resource = (IResource)adaptableObject;
                repository = this.getRepository(resource);
            } else if (adaptableObject instanceof IHistoryView) {
                IHistoryView historyView = (IHistoryView)adaptableObject;
                IHistoryPage historyPage = historyView.getHistoryPage();
                Object input = historyPage.getInput();
                if (input instanceof RepositoryNode) {
                    RepositoryNode node = (RepositoryNode)input;
                    repository = node.getRepository();
                } else if (input instanceof IResource) {
                    repository = this.getRepository((IResource)input);
                }
            } else if (adaptableObject instanceof ISelection) {
                IStructuredSelection structuredSelection = SelectionUtils.getStructuredSelection((ISelection)((ISelection)adaptableObject));
                repository = SelectionUtils.getRepository((IStructuredSelection)structuredSelection);
            } else {
                return null;
            }
            return adapterType.cast(repository);
        }
        return null;
    }

    private Repository getRepository(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        return mapping != null ? mapping.getRepository() : null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{Repository.class};
    }
}

