/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.WithExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.impl.CommandContributionItem;
import org.eclipse.ease.ui.tools.LocationImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class ScriptContributionItem
extends CommandContributionItem {
    private static final Pattern ENABLE_PATTERN = Pattern.compile("enableFor\\((.*)\\)");
    private final IScript fScript;
    private Expression fVisibleExpression = null;

    private static ImageDescriptor getImageDescriptor(String imageLocation) {
        if (imageLocation != null) {
            return LocationImageDescriptor.createFromLocation(imageLocation);
        }
        return null;
    }

    private static Map<String, String> getParameters(IScript script) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.eclipse.ease.commands.script.run.name", script.getPath().toString());
        return parameters;
    }

    public ScriptContributionItem(IScript script) {
        super(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), script.getLocation(), "org.eclipse.ease.commands.script.run", ScriptContributionItem.getParameters(script), ScriptContributionItem.getImageDescriptor(script.getParameters().get("image")), null, null, script.getName(), null, null, 8, null, true));
        this.fScript = script;
    }

    public ScriptContributionItem(IScript script, String enablement) {
        this(script);
        Matcher matcher = ENABLE_PATTERN.matcher(enablement);
        if (matcher.matches()) {
            try {
                WithExpression withExpression = new WithExpression("selection");
                IterateExpression iteratorExpression = new IterateExpression(null, Boolean.FALSE.toString());
                AdaptExpression adaptExpression = new AdaptExpression(matcher.group(1));
                withExpression.add((Expression)iteratorExpression);
                iteratorExpression.add((Expression)adaptExpression);
                this.fVisibleExpression = withExpression;
            }
            catch (CoreException coreException) {
                this.fVisibleExpression = Expression.FALSE;
            }
        }
    }

    @Override
    public void update() {
        this.setLabel(this.fScript.getParameters().get("name"));
        ParameterizedCommand command = this.getCommand();
        command.getParameterMap().putAll(ScriptContributionItem.getParameters(this.fScript));
        super.update();
    }

    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isVisible() {
        if (this.fVisibleExpression != null) {
            try {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                EvaluationResult evaluate = this.fVisibleExpression.evaluate(handlerService.getCurrentState());
                return Boolean.parseBoolean(evaluate.toString());
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return true;
    }
}

