/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.css.spy;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.tools.css.spy.OpenScratchpadHandler;
import org.eclipse.e4.tools.css.spy.OpenSpyHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class SpyInstaller {
    private static final String BUNDLE_ID = "org.eclipse.e4.tools.css.spy";
    public static final String OPEN_SPY_COMMAND_ID = "org.eclipse.e4.css.OpenSpy";
    private static final String SPY_HANDLER_ID = OpenSpyHandler.class.getName();
    private static final String SPY_HANDLER_URI = "bundleclass://org.eclipse.e4.tools.css.spy/" + OpenSpyHandler.class.getName();
    public static final String OPEN_SCRATCHPAD_COMMAND_ID = "org.eclipse.e4.css.OpenSctachpad";
    private static final String SCRATCHPAD_HANDLER_ID = OpenScratchpadHandler.class.getName();
    private static final String SCRATCHPAD_HANDLER_URI = "bundleclass://org.eclipse.e4.tools.css.spy/" + OpenScratchpadHandler.class.getName();
    private static final String CONTRIBUTOR_URI = "platform:/plugin/org.eclipse.e4.tools.css.spy";
    @Inject
    protected MApplication app;
    @Inject
    EModelService modelService;
    @Inject
    @Optional
    protected Logger logger;

    @Execute
    public void execute() {
        this.removeBindingTable("bt.org.eclipse.e4.css.OpenSpy");
        MCommand openSpyCommand = this.installCommand("Open CSS Spy", OPEN_SPY_COMMAND_ID);
        this.installHandler(openSpyCommand, SPY_HANDLER_ID, SPY_HANDLER_URI);
        this.installBinding("org.eclipse.ui.contexts.dialogAndWindow", openSpyCommand, "M2+M3+F5");
        MCommand openScratchpadCommand = this.installCommand("Open CSS Scratchpad", OPEN_SCRATCHPAD_COMMAND_ID);
        this.installHandler(openScratchpadCommand, SCRATCHPAD_HANDLER_ID, SCRATCHPAD_HANDLER_URI);
        this.installBinding("org.eclipse.ui.contexts.dialogAndWindow", openScratchpadCommand, "M2+M3+F6");
    }

    private void removeBindingTable(String tableId) {
        for (MBindingTable table : this.app.getBindingTables()) {
            if (!tableId.equals(table.getElementId())) continue;
            this.app.getBindingTables().remove(table);
            return;
        }
    }

    private MCommand installCommand(String label, String commandId) {
        MCommand cmd2;
        for (MCommand cmd2 : this.app.getCommands()) {
            if (!commandId.equals(cmd2.getElementId())) continue;
            return cmd2;
        }
        cmd2 = (MCommand)this.modelService.createModelElement(MCommand.class);
        cmd2.setCommandName(label);
        cmd2.setElementId(commandId);
        cmd2.setContributorURI(CONTRIBUTOR_URI);
        this.app.getCommands().add(cmd2);
        return cmd2;
    }

    private MHandler installHandler(MCommand cmd, String handlerId, String handlerURI) {
        MHandler hdlr2;
        for (MHandler hdlr2 : this.app.getHandlers()) {
            if (!handlerId.equals(hdlr2.getElementId())) continue;
            return hdlr2;
        }
        hdlr2 = (MHandler)this.modelService.createModelElement(MHandler.class);
        hdlr2.setElementId(handlerId);
        hdlr2.setContributionURI(handlerURI);
        hdlr2.setCommand(cmd);
        hdlr2.setContributorURI(CONTRIBUTOR_URI);
        this.app.getHandlers().add(hdlr2);
        return hdlr2;
    }

    private void installBinding(String bindingContextId, MCommand cmd, String keySeq) {
        MBindingTable bindingTable = null;
        for (MBindingTable table : this.app.getBindingTables()) {
            for (MKeyBinding binding : table.getBindings()) {
                if (binding.getCommand() != cmd) continue;
                if (binding.getTags().contains("type:user")) {
                    this.logInfo("Found user-remapped binding for {0} to {1}: not rebinding", cmd.getElementId(), binding.getKeySequence());
                    return;
                }
                if (binding.getTags().contains("deleted")) {
                    this.logInfo("User deleted binding for {0}: not rebinding", cmd.getElementId());
                    return;
                }
                this.logInfo("Removing existing binding for {0} to {1}", cmd.getElementId(), binding.getKeySequence());
                table.getBindings().remove(binding);
                break;
            }
            if (table.getBindingContext() == null || !bindingContextId.equals(table.getBindingContext().getElementId())) continue;
            bindingTable = table;
        }
        if (bindingTable == null) {
            this.logError("Cannot find table for binding context: {0}", bindingContextId);
            return;
        }
        MKeyBinding binding = (MKeyBinding)this.modelService.createModelElement(MKeyBinding.class);
        binding.setCommand(cmd);
        binding.setKeySequence(keySeq);
        binding.setElementId("kb." + cmd.getElementId());
        binding.setContributorURI(CONTRIBUTOR_URI);
        bindingTable.getBindings().add(binding);
    }

    private void logInfo(String message, Object ... args) {
        if (this.logger == null) {
            return;
        }
        this.logger.info(message, args);
    }

    private void logError(String message, Object ... args) {
        if (this.logger == null) {
            return;
        }
        this.logger.error(message, args);
    }
}

