/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.css.spy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.tools.css.spy.Activator;
import org.eclipse.e4.tools.css.spy.CSSPropertiesContentProvider;
import org.eclipse.e4.tools.css.spy.CSSPropertyProvider;
import org.eclipse.e4.tools.css.spy.TextPopupDialog;
import org.eclipse.e4.tools.css.spy.WidgetTreeProvider;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CssSpyDialog
extends Dialog {
    private Display display;
    private Widget specimen;
    private Widget shown;
    private TreeViewer widgetTreeViewer;
    private WidgetTreeProvider widgetTreeProvider;
    private Button showAllShells;
    private TableViewer cssPropertiesViewer;
    private Text cssRules;
    private List<Shell> highlights = new LinkedList<Shell>();
    private List<Region> highlightRegions = new LinkedList<Region>();
    private Text cssSearchBox;
    private Button showUnsetProperties;
    private Button showCssFragment;
    protected ViewerFilter unsetPropertyFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CSSPropertyProvider) {
                try {
                    return ((CSSPropertyProvider)element).getValue() != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
    };

    public static CSSStylableElement getCSSElement(Object o) {
        if (o instanceof CSSStylableElement) {
            return (CSSStylableElement)o;
        }
        CSSEngine engine = CssSpyDialog.getCSSEngine(o);
        if (engine != null) {
            return (CSSStylableElement)engine.getElement(o);
        }
        return null;
    }

    public static CSSEngine getCSSEngine(Object o) {
        CSSEngine engine = null;
        if (o instanceof CSSStylableElement) {
            CSSStylableElement element = (CSSStylableElement)o;
            engine = WidgetElement.getEngine((Widget)((Widget)element.getNativeWidget()));
        }
        if (engine == null && o instanceof Widget) {
            if (((Widget)o).isDisposed()) {
                return null;
            }
            engine = WidgetElement.getEngine((Widget)((Widget)o));
        }
        if (engine == null && Display.getCurrent() != null) {
            engine = new CSSSWTEngineImpl(Display.getCurrent());
        }
        return engine;
    }

    public CssSpyDialog(Shell parentShell) {
        super(parentShell);
        this.display = parentShell.getDisplay();
        this.setShellStyle(3184);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("CSS Spy");
    }

    public Widget getSpecimen() {
        return this.specimen;
    }

    private boolean isLive() {
        return this.specimen == null;
    }

    public void setSpecimen(Widget specimen) {
        this.specimen = specimen;
        this.update();
    }

    private Widget getActiveSpecimen() {
        if (this.specimen != null) {
            return this.specimen;
        }
        return this.display.getCursorControl();
    }

    protected boolean shouldDismissOnLostFocus() {
        return false;
    }

    protected void update() {
        if (this.getShell() == null) {
            return;
        }
        Widget current = this.getActiveSpecimen();
        if (this.shown == current) {
            return;
        }
        this.shown = current;
        CSSEngine engine = CssSpyDialog.getCSSEngine(this.shown);
        CSSStylableElement element = (CSSStylableElement)engine.getElement((Object)this.shown);
        if (element == null) {
            return;
        }
        this.updateWidgetTreeInput();
        this.revealAndSelect(Collections.singletonList(this.shown));
    }

    private <T> void revealAndSelect(List<T> elements) {
        this.widgetTreeViewer.setSelection((ISelection)new StructuredSelection(elements), true);
    }

    private void updateForWidgetSelection(ISelection sel) {
        this.disposeHighlights();
        if (sel.isEmpty()) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)sel;
        for (Object s : selection.toList()) {
            if (!(s instanceof Widget)) continue;
            this.highlightWidget((Widget)s);
        }
        this.populate(selection.size() == 1 && selection.getFirstElement() instanceof Widget ? (Widget)selection.getFirstElement() : null);
    }

    private void updateWidgetTreeInput() {
        if (this.showAllShells.getSelection()) {
            this.widgetTreeViewer.setInput((Object)this.display);
        } else {
            this.widgetTreeViewer.setInput((Object)new Object[]{this.shown instanceof Control ? ((Control)this.shown).getShell() : this.shown});
        }
        this.performCSSSearch((IProgressMonitor)new NullProgressMonitor());
    }

    protected void populate(Widget selected) {
        Rectangle bounds;
        Composite nw;
        if (selected == null) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText("");
            return;
        }
        if (selected.isDisposed()) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText("*DISPOSED*");
            return;
        }
        CSSStylableElement element = CssSpyDialog.getCSSElement(selected);
        if (element == null) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText("Not a stylable element");
            return;
        }
        this.cssPropertiesViewer.setInput((Object)selected);
        StringBuilder sb = new StringBuilder();
        CSSEngine engine = CssSpyDialog.getCSSEngine(element);
        CSSStyleDeclaration decl = engine.getViewCSS().getComputedStyle((Element)element, null);
        if (element.getCSSStyle() != null) {
            sb.append("\nCSS Inline Style(s):\n  ");
            Activator.join(sb, element.getCSSStyle().split(";"), ";\n  ");
        }
        if (decl != null) {
            sb.append("\n\nCSS Properties:\n");
            try {
                if (decl != null) {
                    sb.append(decl.getCssText());
                }
            }
            catch (Exception e) {
                sb.append(e);
            }
        }
        if (element.getStaticPseudoInstances().length > 0) {
            sb.append("\n\nStatic Pseudoinstances:\n  ");
            Activator.join(sb, element.getStaticPseudoInstances(), "\n  ");
        }
        if (element.getCSSClass() != null) {
            sb.append("\n\nCSS Classes:\n  ");
            Activator.join(sb, element.getCSSClass().split(" +"), "\n  ");
        }
        if (element.getAttribute("style") != null) {
            sb.append("\n\nSWT Style Bits:\n  ");
            Activator.join(sb, element.getAttribute("style").split(" +"), "\n  ");
        }
        sb.append("\n\nCSS Class Element:\n  ").append(element.getClass().getName());
        if (element.getNativeWidget() instanceof Shell && ((Shell)element.getNativeWidget()).getParent() != null) {
            nw = (Shell)element.getNativeWidget();
            sb.append("\n\nShell parent: ").append(nw.getParent());
        }
        if (element.getNativeWidget() instanceof Composite) {
            nw = (Composite)element.getNativeWidget();
            sb.append("\n\nSWT Layout: ").append(nw.getLayout());
        }
        if ((bounds = this.getBounds(selected)) != null) {
            sb.append("\nBounds: x=").append(bounds.x).append(" y=").append(bounds.y);
            sb.append(" h=").append(bounds.height).append(" w=").append(bounds.width);
        }
        if (element.getNativeWidget() instanceof Widget) {
            Widget w = (Widget)element.getNativeWidget();
            if (w.getData() != null) {
                sb.append("\nWidget data: ").append(w.getData());
            }
            if (w.getData("org.eclipse.swt.skin.id") != null) {
                sb.append("\nWidget Skin ID (").append("org.eclipse.swt.skin.id").append("): ").append(w.getData("org.eclipse.swt.skin.id"));
            }
            if (w.getData("org.eclipse.swt.skin.class") != null) {
                sb.append("\nWidget Skin Class (").append("org.eclipse.swt.skin.class").append("): ").append(w.getData("org.eclipse.swt.skin.class"));
            }
        }
        this.cssRules.setText(sb.toString().trim());
        this.disposeHighlights();
        this.highlightWidget(selected);
    }

    private Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        return null;
    }

    private void highlightWidget(Widget selected) {
        if (selected == null || selected.isDisposed()) {
            return;
        }
        Rectangle bounds = this.getBounds(selected);
        if (bounds == null) {
            return;
        }
        Shell selectedShell = this.getShell(selected);
        Shell highlight = new Shell(selectedShell, 540680);
        highlight.setBackground(this.display.getSystemColor(3));
        Region highlightRegion = new Region();
        highlightRegion.add(0, 0, 1, bounds.height + 2);
        highlightRegion.add(0, 0, bounds.width + 2, 1);
        highlightRegion.add(bounds.width + 1, 0, 1, bounds.height + 2);
        highlightRegion.add(0, bounds.height + 1, bounds.width + 2, 1);
        highlight.setRegion(highlightRegion);
        highlight.setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
        highlight.setEnabled(false);
        highlight.setVisible(true);
        this.highlights.add(highlight);
        this.highlightRegions.add(highlightRegion);
    }

    private void disposeHighlights() {
        for (Shell highlight : this.highlights) {
            highlight.dispose();
        }
        this.highlights.clear();
        for (Region region : this.highlightRegions) {
            region.dispose();
        }
        this.highlightRegions.clear();
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof Shell) {
            return ((Shell)widget).getBounds();
        }
        if (widget instanceof Control) {
            Control control = (Control)widget;
            Rectangle bounds = control.getBounds();
            return control.getDisplay().map((Control)control.getParent(), null, bounds);
        }
        if (widget instanceof ToolItem) {
            ToolItem item = (ToolItem)widget;
            Rectangle bounds = item.getBounds();
            return item.getDisplay().map((Control)item.getParent(), null, bounds);
        }
        if (widget instanceof CTabItem) {
            CTabItem item = (CTabItem)widget;
            Rectangle bounds = item.getBounds();
            return item.getDisplay().map((Control)item.getParent(), null, bounds);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Composite top = new Composite(outer, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(top);
        this.cssSearchBox = new Text(top, 2944);
        this.cssSearchBox.setMessage("CSS Selector");
        this.cssSearchBox.setToolTipText("Highlight matching widgets");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cssSearchBox);
        this.showAllShells = new Button(top, 32);
        this.showAllShells.setText("All shells");
        GridDataFactory.swtDefaults().applyTo((Control)this.showAllShells);
        GridDataFactory.fillDefaults().applyTo((Control)top);
        SashForm sashForm = new SashForm(outer, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite widgetsComposite = new Composite((Composite)sashForm, 0);
        this.widgetTreeViewer = new TreeViewer(widgetsComposite, 2050);
        this.widgetTreeProvider = new WidgetTreeProvider();
        this.widgetTreeViewer.setContentProvider((IContentProvider)this.widgetTreeProvider);
        this.widgetTreeViewer.setAutoExpandLevel(0);
        this.widgetTreeViewer.getTree().setLinesVisible(true);
        this.widgetTreeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.widgetTreeViewer);
        TreeViewerColumn widgetTypeColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetTypeColumn.getColumn().setWidth(100);
        widgetTypeColumn.getColumn().setText("Widget");
        widgetTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyDialog.getCSSElement(item);
                return String.valueOf(element.getLocalName()) + " (" + element.getNamespaceURI() + ")";
            }
        });
        TreeViewerColumn widgetClassColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetClassColumn.getColumn().setText("CSS Class");
        widgetClassColumn.getColumn().setWidth(100);
        widgetClassColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyDialog.getCSSElement(item);
                if (element.getCSSClass() == null) {
                    return null;
                }
                String[] classes = element.getCSSClass().split(" +");
                return classes.length <= 1 ? classes[0] : String.valueOf(classes[0]) + " (+" + (classes.length - 1) + " others)";
            }

            public String getToolTipText(Object item) {
                CSSStylableElement element = CssSpyDialog.getCSSElement(item);
                if (element == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(element.getLocalName()).append(" (").append(element.getNamespaceURI()).append(")");
                if (element.getCSSClass() != null) {
                    sb.append("\nClasses:\n  ");
                    Activator.join(sb, element.getCSSClass().split(" +"), "\n  ");
                }
                return sb.toString();
            }
        });
        TreeViewerColumn widgetIdColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetIdColumn.getColumn().setWidth(100);
        widgetIdColumn.getColumn().setText("CSS Id");
        widgetIdColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyDialog.getCSSElement(item);
                return element.getCSSId();
            }
        });
        TreeColumnLayout widgetsTableLayout = new TreeColumnLayout();
        widgetsTableLayout.setColumnData((Widget)widgetTypeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        widgetsTableLayout.setColumnData((Widget)widgetIdColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        widgetsTableLayout.setColumnData((Widget)widgetClassColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        widgetsComposite.setLayout((Layout)widgetsTableLayout);
        Composite container = new Composite((Composite)sashForm, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        Label lblCssProperties = new Label(container, 0);
        lblCssProperties.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblCssProperties.setText("CSS Properties");
        Label lblCssRules = new Label(container, 0);
        lblCssRules.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblCssRules.setText("CSS Rules");
        Composite propsComposite = new Composite(container, 2048);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.minimumHeight = 50;
        propsComposite.setLayoutData((Object)gridData);
        this.cssPropertiesViewer = new TableViewer(propsComposite, 68352);
        this.cssPropertiesViewer.setContentProvider((IContentProvider)new CSSPropertiesContentProvider());
        this.cssPropertiesViewer.getTable().setLinesVisible(true);
        this.cssPropertiesViewer.getTable().setHeaderVisible(true);
        this.cssPropertiesViewer.setComparator(new ViewerComparator());
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.cssPropertiesViewer.getTable());
        TableViewerEditor.create((TableViewer)this.cssPropertiesViewer, (SWTFocusCellManager)new TableViewerFocusCellManager(this.cssPropertiesViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.cssPropertiesViewer)), (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.cssPropertiesViewer), (int)58);
        TableViewerColumn propName = new TableViewerColumn(this.cssPropertiesViewer, 0);
        propName.getColumn().setWidth(100);
        propName.getColumn().setText("Property");
        propName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CSSPropertyProvider)element).getPropertyName();
            }
        });
        TableViewerColumn propValue = new TableViewerColumn(this.cssPropertiesViewer, 0);
        propValue.getColumn().setWidth(100);
        propValue.getColumn().setText("Value");
        propValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                try {
                    return ((CSSPropertyProvider)element).getValue();
                }
                catch (Exception e) {
                    System.err.println("Error fetching property: " + element + ": " + e);
                    return null;
                }
            }
        });
        propValue.setEditingSupport(new EditingSupport((ColumnViewer)this.cssPropertiesViewer){

            protected CellEditor getCellEditor(Object element) {
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                try {
                    String value = ((CSSPropertyProvider)element).getValue();
                    return value == null ? "" : value;
                }
                catch (Exception exception) {
                    return "";
                }
            }

            protected void setValue(Object element, Object value) {
                try {
                    if (value == null || ((String)value).trim().length() == 0) {
                        return;
                    }
                    CSSPropertyProvider provider = (CSSPropertyProvider)element;
                    provider.setValue((String)value);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)CssSpyDialog.this.getShell(), (String)"Error", (String)("Unable to set property:\n\n" + e.getMessage()));
                }
                CssSpyDialog.this.cssPropertiesViewer.update(element, null);
            }
        });
        TableColumnLayout propsTableLayout = new TableColumnLayout();
        propsTableLayout.setColumnData((Widget)propName.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        propsTableLayout.setColumnData((Widget)propValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        propsComposite.setLayout((Layout)propsTableLayout);
        this.cssRules = new Text(container, 2818);
        this.cssRules.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.showUnsetProperties = new Button(container, 32);
        this.showUnsetProperties.setText("Show unset properties");
        this.showCssFragment = new Button(container, 8);
        this.showCssFragment.setText("Show CSS fragment");
        this.showCssFragment.setToolTipText("Generates CSS rule block for the selected widget");
        new Label(container, 0);
        this.cssSearchBox.addModifyListener(new ModifyListener(){
            private Runnable updater;
            private IProgressMonitor monitor;

            public void modifyText(ModifyEvent e) {
                if (this.monitor != null) {
                    this.monitor.setCanceled(false);
                }
                this.updater = new Runnable(){

                    @Override
                    public void run() {
                        if (updater == this) {
                            CssSpyDialog cssSpyDialog = CssSpyDialog.this;
                            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                            monitor = (IProgressMonitor)nullProgressMonitor;
                            cssSpyDialog.performCSSSearch((IProgressMonitor)nullProgressMonitor);
                        }
                    }
                };
                CssSpyDialog.this.display.timerExec(200, this.updater);
            }
        });
        this.cssSearchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    CssSpyDialog.this.widgetTreeViewer.getControl().setFocus();
                }
            }
        });
        this.widgetTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CssSpyDialog.this.updateForWidgetSelection(event.getSelection());
                CssSpyDialog.this.showCssFragment.setEnabled(!event.getSelection().isEmpty());
            }
        });
        if (this.isLive()) {
            container.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    CssSpyDialog.this.update();
                }
            });
        }
        if (this.shouldDismissOnLostFocus()) {
            container.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    CssSpyDialog.this.setReturnCode(0);
                    CssSpyDialog.this.close();
                }
            });
        }
        container.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    CssSpyDialog.this.cancelPressed();
                } else if (e.character == '\r' | e.character == '\n') {
                    CssSpyDialog.this.okPressed();
                }
            }
        });
        this.showAllShells.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CssSpyDialog.this.updateWidgetTreeInput();
            }
        });
        outer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CssSpyDialog.this.dispose();
            }
        });
        this.showUnsetProperties.setSelection(true);
        this.showUnsetProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CssSpyDialog.this.showUnsetProperties.getSelection()) {
                    CssSpyDialog.this.cssPropertiesViewer.removeFilter(CssSpyDialog.this.unsetPropertyFilter);
                } else {
                    CssSpyDialog.this.cssPropertiesViewer.addFilter(CssSpyDialog.this.unsetPropertyFilter);
                }
            }
        });
        this.showCssFragment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CssSpyDialog.this.showCssFragment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.update();
        sashForm.setWeights(new int[]{50, 50});
        this.widgetTreeViewer.getControl().setFocus();
        return outer;
    }

    protected void showCssFragment() {
        if (!(this.widgetTreeViewer.getSelection() instanceof IStructuredSelection) || this.widgetTreeViewer.getSelection().isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = ((IStructuredSelection)this.widgetTreeViewer.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Widget) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                this.addCssFragment((Widget)o, sb);
            }
            ++n2;
        }
        TextPopupDialog tpd = new TextPopupDialog(this.widgetTreeViewer.getControl().getShell(), "CSS", sb.toString(), true, "Escape to dismiss");
        tpd.open();
    }

    private void addCssFragment(Widget w, StringBuilder sb) {
        CSSValue cssValue;
        String declValue;
        CSSStylableElement element = CssSpyDialog.getCSSElement(w);
        if (element == null) {
            return;
        }
        sb.append(element.getLocalName());
        if (element.getCSSId() != null) {
            sb.append("#").append(element.getCSSId());
        }
        sb.append(" {");
        CSSEngine engine = CssSpyDialog.getCSSEngine(element);
        CSSStyleDeclaration decl = engine.getViewCSS().getComputedStyle((Element)element, null);
        ArrayList propertyNames = new ArrayList(engine.getCSSProperties((Object)element));
        Collections.sort(propertyNames);
        int count = 0;
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            String genValue = this.trim(engine.retrieveCSSProperty((Object)element, propertyName, ""));
            declValue = null;
            if (genValue == null) continue;
            if (decl != null && (cssValue = decl.getPropertyCSSValue(propertyName)) != null) {
                declValue = this.trim(cssValue.getCssText());
            }
            if (count == 0) {
                sb.append("\n  /* actual values */");
            }
            sb.append("\n  ").append(propertyName).append(": ").append(genValue).append(";");
            if (declValue != null) {
                sb.append("\t/* declared in CSS: ").append(declValue).append(" */");
            }
            ++count;
            iter.remove();
        }
        if (decl != null) {
            int declCount = 0;
            for (String propertyName : propertyNames) {
                declValue = null;
                cssValue = decl.getPropertyCSSValue(propertyName);
                if (cssValue != null) {
                    declValue = this.trim(cssValue.getCssText());
                }
                if (declValue == null) continue;
                if (declCount == 0) {
                    sb.append("\n\n  /* declared in CSS rules */");
                }
                sb.append("\n  ").append(propertyName).append(": ").append(declValue).append(";");
                ++count;
                ++declCount;
            }
        }
        sb.append(count > 0 ? "\n}" : "}");
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() > 0 ? s : null;
    }

    protected void performCSSSearch(IProgressMonitor progress) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        this.performCSSSearch(progress, this.cssSearchBox.getText(), widgets);
        if (!progress.isCanceled()) {
            this.revealAndSelect(widgets);
        }
    }

    private void performCSSSearch(IProgressMonitor monitor, String text, Collection<Widget> results) {
        if (text.trim().length() == 0) {
            return;
        }
        this.widgetTreeViewer.collapseAll();
        Object[] roots = this.widgetTreeProvider.getElements(this.widgetTreeViewer.getInput());
        monitor.beginTask("Searching for \"" + text + "\"", roots.length * 10);
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            CSSStylableElement element = CssSpyDialog.getCSSElement(root);
            if (element != null) {
                CSSEngine engine = CssSpyDialog.getCSSEngine(root);
                try {
                    SelectorList selectors = engine.parseSelectors(text);
                    monitor.worked(2);
                    this.processCSSSearch((IProgressMonitor)new SubProgressMonitor(monitor, 8), engine, selectors, element, null, results);
                }
                catch (CSSParseException e) {
                    System.out.println(e.toString());
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
            }
            ++n2;
        }
        monitor.done();
    }

    private void processCSSSearch(IProgressMonitor monitor, CSSEngine engine, SelectorList selectors, CSSStylableElement element, String pseudo, Collection<Widget> results) {
        if (monitor.isCanceled()) {
            return;
        }
        NodeList children = element.getChildNodes();
        monitor.beginTask("Searching", 5 + 5 * children.getLength());
        boolean matched = false;
        int i = 0;
        while (i < selectors.getLength()) {
            matched = engine.matches(selectors.item(i), (Object)element, pseudo);
            if (matched) break;
            ++i;
        }
        if (matched) {
            results.add((Widget)element.getNativeWidget());
        }
        monitor.worked(5);
        i = 0;
        while (i < children.getLength()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.processCSSSearch((IProgressMonitor)new SubProgressMonitor(monitor, 5), engine, selectors, (CSSStylableElement)children.item(i), pseudo, results);
            ++i;
        }
        monitor.done();
    }

    protected void dispose() {
        this.disposeHighlights();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }
}

