/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.e4.emf.ecore.javascript.AbstractJavascriptTest;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptSupportTest
extends AbstractJavascriptTest {
    private static String test11Script = "function getPrefixedName(string) { return string + \"+\" + this.name;}function getSuffixedName(string) { return this.name + \"*\" + string;}";

    protected void setUp() throws Exception {
        this.setUp("javascriptSupportTest.xmi");
    }

    public void testNameProperty() {
        EObject c11 = (EObject)this.resource.getContents().get(0);
        Object name = this.getFeatureValue(c11, "name");
        Assert.assertTrue((boolean)(name instanceof String));
        Object result = this.javascriptSupport.getVariable((Resource)this.resource, "$" + name);
        Assert.assertEquals((Object)c11, (Object)result);
        String c2Name = "c2";
        Object c2 = this.javascriptSupport.getProperty(c11, "$" + c2Name);
        Assert.assertTrue((boolean)(c2 instanceof EObject));
        Assert.assertEquals((Object)c11, (Object)((EObject)c2).eContainer());
        Assert.assertEquals((String)this.javascriptSupport.getName((EObject)c2), (String)c2Name);
    }

    public void testContainerProperty() {
        EObject c11 = (EObject)this.resource.getContents().get(0);
        EObject c2 = (EObject)c11.eContents().get(0);
        Assert.assertEquals((Object)c11, (Object)this.javascriptSupport.getProperty(c2, "$"));
    }

    public void testResourceNames() {
        EObject c11 = (EObject)this.resource.getContents().get(0);
        Scriptable scope = this.javascriptSupport.getScope((Object)this.resource);
        Object name = this.getFeatureValue(c11, "name");
        Assert.assertEquals((Object)c11, (Object)scope.get(("$" + name).intern(), scope));
        String c2Name = "$c2".intern();
        Object c2 = this.javascriptSupport.getProperty(c11, c2Name);
        Assert.assertEquals((Object)c2, (Object)scope.get(c2Name, scope));
        this.setFeatureValue((EObject)c2, "c1", null);
        Assert.assertEquals(null, (Object)scope.get(c2Name, scope));
        this.setFeatureValue((EObject)c2, "c1", c11);
        Assert.assertEquals((Object)c2, (Object)scope.get(c2Name, scope));
        this.setFeatureValue((EObject)c2, "name", "c2Alias");
        Assert.assertEquals(null, (Object)scope.get(c2Name, scope));
        Assert.assertEquals((Object)c2, (Object)scope.get("$c2Alias".intern(), scope));
    }

    public void testCallMethodInModel_getPrefixedName() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        String prefix = "Name: ";
        Object result = this.javascriptSupport.callMethod((Object)c1, "getPrefixedName", new Object[]{prefix}, this.rethrowException);
        Assert.assertEquals((Object)(String.valueOf(prefix) + this.getFeatureValue(c1, "name")), (Object)result);
    }

    public void testCallMethodInModel_getSuffixedName() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        for (EObject c2 : (List)c1.eGet(c1.eClass().getEStructuralFeature("c2s"))) {
            if (!"C2".equals(c2.eClass().getName())) continue;
            String suffix = " = name";
            Object result = this.javascriptSupport.callMethod((Object)c2, "getSuffixedName", new Object[]{suffix}, this.rethrowException);
            Assert.assertEquals((Object)(this.getFeatureValue(c2, "name") + suffix), (Object)result);
        }
    }

    public void testCallMethodInModel_createC2() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        Object result = this.javascriptSupport.callMethod((Object)c1, "createC2", new Object[]{"c2Name"}, this.rethrowException);
        Assert.assertTrue((boolean)(result instanceof EObject));
        Assert.assertEquals((String)"C2", (String)((EObject)result).eClass().getName());
        EObject c2 = (EObject)result;
        Assert.assertEquals((Object)c1, (Object)this.getFeatureValue(c2, "c1"));
    }

    public void testCallFunctionInFile_C1ContainsC2() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        Object c2 = this.javascriptSupport.callMethod((Object)c1, "createC2", new Object[]{"c2Name"}, this.rethrowException);
        Object result = this.javascriptSupport.callFunction((Resource)this.resource, "C1ContainsC2", new Object[]{c1, c2}, this.rethrowException);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testGetIds() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        this.javascriptSupport.callMethod((Object)c1, "createC2", new Object[]{"c2Name"}, this.rethrowException);
        List<Object> c1Ids = Arrays.asList(((Scriptable)this.javascriptSupport.wrap((Object)c1)).getIds());
        ArrayList<Object> expectedIds = new ArrayList<Object>(Arrays.asList("name", "string1", "int1", "c2s", "getPrefixedName", "createC2", "$c2", "$c31", "$c32", "$c2Name"));
        List<Object> indices = Arrays.asList(new Integer(0), new Integer(1), new Integer(2), new Integer(3));
        expectedIds.addAll(indices);
        Assert.assertTrue((boolean)c1Ids.containsAll(expectedIds));
        List<Object> c1ContentIds = Arrays.asList(((Scriptable)this.javascriptSupport.wrap((Object)c1.eContents())).getIds());
        Assert.assertTrue((boolean)c1ContentIds.containsAll(indices));
    }

    public void testListMethod_findInstances() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        Object result1 = this.javascriptSupport.callFunction((Resource)this.resource, "findInstances", new Object[]{this.resource, c1.eClass()}, this.rethrowException);
        Assert.assertTrue((boolean)(result1 instanceof List));
        List list1 = (List)result1;
        Assert.assertEquals((int)1, (int)list1.size());
        Assert.assertEquals((Object)c1, list1.get(0));
        List c2s = (List)this.getFeatureValue(c1, "c2s");
        EObject c2 = (EObject)c2s.get(0);
        EObject c31 = (EObject)c2s.get(1);
        EObject c32 = (EObject)c2s.get(2);
        Object result2 = this.javascriptSupport.callFunction((Resource)this.resource, "findInstances", new Object[]{this.resource, c2.eClass()}, this.rethrowException);
        Assert.assertTrue((boolean)(result2 instanceof List));
        List list2 = (List)result2;
        Assert.assertEquals((int)3, (int)list2.size());
        Assert.assertEquals((Object)c2, list2.get(0));
        Assert.assertEquals((Object)c31, list2.get(1));
        Assert.assertEquals((Object)c32, list2.get(2));
    }

    public void testCallResourceFunction_resource() {
        Object result = this.javascriptSupport.callFunction((Resource)this.resource, "resource", new Object[0], this.rethrowException);
        Assert.assertEquals((Object)this.resource, (Object)result);
    }

    public void testCallEClassMethod_isA() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        EClass eClass1 = c1.eClass();
        Scriptable jsEClass = (Scriptable)this.javascriptSupport.wrap((Object)eClass1);
        Assert.assertTrue((boolean)ScriptableObject.hasProperty((Scriptable)jsEClass, (String)"isA"));
        Object result = this.javascriptSupport.callMethod((Object)c1, "isA", new Object[]{eClass1}, this.rethrowException);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testCallMethodsInFile() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        for (EObject c2 : (List)c1.eGet(c1.eClass().getEStructuralFeature("c2s"))) {
            String suffix = " = name";
            Object result = this.javascriptSupport.callMethod((Object)c2, "getSuffixedName", new Object[]{suffix}, this.rethrowException);
            Object c2Name = this.getFeatureValue(c2, "name");
            if ("C3".equals(c2.eClass().getName())) {
                Assert.assertEquals((Object)(c2Name + "_" + suffix), (Object)result);
                String prefix = "name = ";
                result = this.javascriptSupport.callMethod((Object)c2, "getFixedName", new Object[]{prefix, suffix}, this.rethrowException);
                Assert.assertEquals((Object)(String.valueOf(prefix) + "_" + c2Name + "-" + c2Name + "_" + suffix), (Object)result);
                continue;
            }
            Assert.assertEquals((Object)(c2Name + suffix), (Object)result);
        }
    }

    public void testCallInstanceMethodsInScript() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        int n = 0;
        for (EObject c2 : (List)c1.eGet(c1.eClass().getEStructuralFeature("c2s"))) {
            if ("C3".equals(c2.eClass().getName()) && n == 0) {
                Scriptable wrapper = (Scriptable)this.javascriptSupport.wrap((Object)c2);
                this.javascriptSupport.evaluate(test11Script, (Object)wrapper.getPrototype(), true);
            }
            if (!"C3".equals(c2.eClass().getName())) continue;
            String suffix = " = name";
            Object result = this.javascriptSupport.callMethod((Object)c2, "getSuffixedName", new Object[]{suffix}, this.rethrowException);
            Object c2Name = this.getFeatureValue(c2, "name");
            Assert.assertEquals((Object)(c2Name + (n == 0 ? "*" : "_") + suffix), (Object)result);
            String prefix = "name = ";
            result = this.javascriptSupport.callMethod((Object)c2, "getFixedName", new Object[]{prefix, suffix}, this.rethrowException);
            Assert.assertEquals((Object)(String.valueOf(prefix) + (n == 0 ? "+" : "_") + c2Name + "-" + c2Name + (n == 0 ? "*" : "_") + suffix), (Object)result);
            ++n;
        }
    }

    public void testChangeEventMethod_onSetTitle() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        this.javascriptSupport.supportNotifications((Notifier)c1);
        for (EObject c2 : (List)c1.eGet(c1.eClass().getEStructuralFeature("c2s"))) {
            if (!"C3".equals(c2.eClass().getName())) continue;
            this.setFeatureValue(c2, "title", "Mr");
            Assert.assertEquals((Object)"Mr Hacker", (Object)this.getFeatureValue(c2, "title"));
        }
    }

    public void testPackageVariable() {
        EObject c1 = (EObject)this.resource.getContents().get(0);
        this.javascriptSupport.wrap((Object)c1);
        EPackage c1ClassPackage = c1.eClass().getEPackage();
        String packVariableName = this.javascriptSupport.getNamePropertyName((EObject)c1ClassPackage);
        JavascriptSupportTest.assertEquals((Object)c1ClassPackage, (Object)this.javascriptSupport.getVariable(null, packVariableName));
    }

    public void testClassLoader(boolean ignore) {
        Object result = this.javascriptSupport.evaluate("var test = new Packages.org.eclipse.e4.emf.ecore.javascript.JavascriptSupportTest(); test", (Object)this.javascriptSupport.getResourceScope((Resource)this.resource), true);
        JavascriptSupportTest.assertNotNull((Object)result);
        JavascriptSupportTest.assertTrue((boolean)(result instanceof JavascriptSupportTest));
    }
}

