/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;

public class UnmapAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        block6: {
            super.selectionChanged(action, selection);
            if (this.getSelection().size() != 1) {
                action.setEnabled(false);
                return;
            }
            ISemanticResource resource = (ISemanticResource)this.getSelection().getFirstElement();
            if (resource != null && resource instanceof ISemanticProject) {
                IProject project = (IProject)resource.getAdaptedResource();
                try {
                    if (resource.getPersistentProperty(DISABLE_ALL_SFS_ACTIONS) != null) {
                        action.setEnabled(false);
                        break block6;
                    }
                    action.setEnabled(RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider") != null);
                }
                catch (CoreException coreException) {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
    }

    public void run(IAction action) {
        final IProject project = (IProject)((ISemanticProject)this.getSelection().getFirstElement()).getAdaptedResource();
        try {
            IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    RepositoryProvider.unmap((IProject)project);
                    project.refreshLocal(2, monitor);
                }
            };
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(myRunnable, workspace.getRuleFactory().refreshRule((IResource)project), 0, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.UnmapAction_Unmap_XGRP, null, (IStatus)e.getStatus());
        }
    }
}

