/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.internal.resources.semantic.SemanticFileStore;
import org.eclipse.core.internal.resources.semantic.ui.KeyValuePair;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class PropertiesContentProvider
implements ITreeContentProvider {
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss::SSS");
    private SFSBrowserTreeObject treeObject;

    public static void initTree(TreeViewer tv, int width) {
        Tree tree = tv.getTree();
        TreeColumn c1 = new TreeColumn(tree, 0);
        c1.setText(Messages.PropertiesContentProvider_Key_XGRP);
        c1.setWidth(width);
        TreeColumn c2 = new TreeColumn(tree, 0);
        c2.setText(Messages.PropertiesContentProvider_Value_XGRP);
        c2.setWidth(width);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public Object[] getElements(Object inputElement) {
        String remoteUri;
        String contentProvider;
        this.treeObject = (SFSBrowserTreeObject)inputElement;
        ISemanticFileStore sfs = (ISemanticFileStore)this.treeObject.getStore();
        ArrayList<KeyValuePair> props = new ArrayList<KeyValuePair>();
        Date modified = new Date(sfs.fetchInfo().getLastModified());
        props.add(new KeyValuePair(Messages.PropertiesContentProvider_LastModified_XFLD, this.df.format(modified)));
        try {
            props.add(new KeyValuePair(Messages.PropertiesContentProvider_ProviderID_XFLD, this.nullToSpace(sfs.getEffectiveContentProviderID())));
        }
        catch (CoreException coreException) {
            props.add(new KeyValuePair(Messages.PropertiesContentProvider_ProviderID_XFLD, Messages.PropertiesContentProvider_ExceptionGettingValue_XMSG));
        }
        try {
            contentProvider = this.nullToSpace(sfs.getEffectiveContentProvider().getClass().getName());
        }
        catch (CoreException coreException) {
            contentProvider = Messages.PropertiesContentProvider_ExceptionGettingValue_XMSG;
        }
        props.add(new KeyValuePair(Messages.PropertiesContentProvider_EffectiveContentProvider_XFLD, contentProvider));
        props.add(new KeyValuePair(Messages.PropertiesContentProvider_PersistentContentProviderID_XFLD, this.nullToSpace(sfs.getContentProviderID())));
        boolean isContentProviderRootNode = false;
        try {
            if (sfs.getEffectiveContentProvider().getRootStore().getPath().equals((Object)sfs.getPath())) {
                isContentProviderRootNode = true;
            }
            props.add(new KeyValuePair(Messages.PropertiesContentProvider_IsRootNode_XFLD, String.valueOf(isContentProviderRootNode)));
        }
        catch (Exception exception) {
            props.add(new KeyValuePair(Messages.PropertiesContentProvider_IsRootNode_XFLD, Messages.PropertiesContentProvider_ExceptionGettingValue_XMSG));
        }
        try {
            remoteUri = this.nullToSpace(sfs.getRemoteURIString());
        }
        catch (CoreException coreException) {
            remoteUri = Messages.PropertiesContentProvider_ExceptionGettingValue_XMSG;
        }
        props.add(new KeyValuePair(Messages.PropertiesContentProvider_RemoteUri_XFLD, remoteUri));
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(Messages.PropertiesContentProvider_ResInfoAttributes_XGRP);
        headers.add(Messages.PropertiesContentProvider_PersistentProps_XGRP);
        headers.add(Messages.PropertiesContentProvider_SessionProps_XGRP);
        Object[] result = new Object[props.size() + headers.size()];
        System.arraycopy(props.toArray(), 0, result, 0, props.size());
        System.arraycopy(headers.toArray(), 0, result, props.size(), headers.size());
        return result;
    }

    private String nullToSpace(String name) {
        if (name == null) {
            return "";
        }
        return name;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeObject = (SFSBrowserTreeObject)newInput;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String) {
            if (Messages.PropertiesContentProvider_PersistentProps_XGRP.equals(parentElement)) {
                Map props;
                ISemanticFileStore store = (ISemanticFileStore)this.treeObject.getStore();
                try {
                    props = store.getPersistentProperties();
                }
                catch (CoreException coreException) {
                    return this.getChildExceptionMap();
                }
                ArrayList<KeyValuePair> resultMap = new ArrayList<KeyValuePair>();
                for (Map.Entry entry : props.entrySet()) {
                    resultMap.add(new KeyValuePair(((QualifiedName)entry.getKey()).toString(), (String)entry.getValue()));
                }
                return resultMap.toArray();
            }
            if (Messages.PropertiesContentProvider_SessionProps_XGRP.equals(parentElement)) {
                Map props;
                ISemanticFileStore store = (ISemanticFileStore)this.treeObject.getStore();
                try {
                    props = store.getSessionProperties();
                }
                catch (CoreException coreException) {
                    return this.getChildExceptionMap();
                }
                ArrayList<KeyValuePair> resultMap = new ArrayList<KeyValuePair>();
                for (Map.Entry entry : props.entrySet()) {
                    resultMap.add(new KeyValuePair(((QualifiedName)entry.getKey()).toString(), String.valueOf(entry.getValue())));
                }
                return resultMap.toArray();
            }
            if (Messages.PropertiesContentProvider_ResInfoAttributes_XGRP.equals(parentElement)) {
                try {
                    ISemanticResourceInfo info = ((SemanticFileStore)this.treeObject.getStore()).fetchResourceInfo(0, null);
                    ArrayList<KeyValuePair> resultMap = new ArrayList<KeyValuePair>();
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_ReadOnly_XFLD, String.valueOf(info.isReadOnly())));
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_LocalOnly_XFLD, String.valueOf(info.isLocalOnly())));
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_LockingSupported_XFLD, String.valueOf(info.isLockingSupported())));
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_Locked_XFLD, String.valueOf(info.isLocked())));
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_ExistsRemotely_XFLD, String.valueOf(info.existsRemotely())));
                    resultMap.add(new KeyValuePair(Messages.PropertiesContentProvider_ContentType_XFLD, this.nullToSpace(info.getContentType())));
                    return resultMap.toArray();
                }
                catch (Exception exception) {
                    return this.getChildExceptionMap();
                }
            }
        }
        return null;
    }

    private Object[] getChildExceptionMap() {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        result.add(new KeyValuePair(Messages.PropertiesContentProvider_ExceptionGettingChildren_XMSG, ""));
        return result.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof String;
    }
}

