/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.DestinationsCategoryExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;

public class DestinationsCategoryExtensionParserTest
extends AbstractExtensionPointParserTest<IDestinationCategoryDescription> {
    private static final String CATEGORY_ID = "mycategoryid";
    private static final String CATEGORY_NAME = "My Category";
    private static final Class<? extends ISearchDestination> DESTINATIONS_CLASS = MyTestDestination.class;
    private static final String DESTINATION_PROVIDER_ID = "mydestprovider";

    protected AbstractExtensionPointParser<IDestinationCategoryDescription> createParser(IExtensionRegistry registry) {
        return new DestinationsCategoryExtensionParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        registryBuilder.addDestinationCategory(CATEGORY_ID, CATEGORY_NAME, DESTINATIONS_CLASS);
        registryBuilder.addDestinationsProvider(DESTINATION_PROVIDER_ID, CATEGORY_ID, null, null, null);
    }

    protected void verifyContributions(List<IDestinationCategoryDescription> contributions) {
        Assert.assertEquals((String)"One destination category expected", (long)1L, (long)contributions.size());
        IDestinationCategoryDescription contribution = contributions.get(0);
        Assert.assertEquals((String)"Unexpected id", (Object)CATEGORY_ID, (Object)contribution.getId());
        Assert.assertEquals((String)"Unexpected name", (Object)CATEGORY_NAME, (Object)contribution.getDisplayName());
        Assert.assertTrue((String)"Unexpected destinations class", (boolean)ISearchDestination.class.isAssignableFrom(contribution.getDestinationsClass()));
        List destProviderIds = contribution.getDestinationProviderIds();
        Assert.assertEquals((String)"One destination provider expected", (long)1L, (long)destProviderIds.size());
        Assert.assertTrue((String)"Test dest provider not returned", (boolean)destProviderIds.contains(DESTINATION_PROVIDER_ID));
    }

    private class MyTestDestination
    implements ISearchDestination {
        private MyTestDestination() {
        }

        public String getDisplayName() {
            return "TEST";
        }
    }
}

