/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.DebugHelper;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.internal.contexts.IEclipseContextDebugger;
import org.eclipse.e4.core.internal.contexts.ILookupStrategy;
import org.eclipse.e4.core.internal.contexts.TrackableComputationExt;
import org.eclipse.e4.core.internal.contexts.ValueComputation;
import org.eclipse.e4.core.internal.contexts.osgi.ContextDebugHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseContext
implements IEclipseContext {
    public static final String PARENT = "parentContext";
    public static final String DEBUG_STRING = "debugString";
    static ThreadLocal<Computation> currentComputation = new ThreadLocal();
    private Map<String, Set<Computation>> listeners = Collections.synchronizedMap(new HashMap());
    final Map<String, ValueComputation> localValueComputations = Collections.synchronizedMap(new HashMap());
    final Map<String, Object> localValues = Collections.synchronizedMap(new HashMap());
    private final ILookupStrategy strategy;
    private ArrayList<String> modifiable;
    private List<Computation> waiting;
    private Set<WeakReference<EclipseContext>> children = new HashSet<WeakReference<EclipseContext>>();
    private Set<IContextDisposalListener> notifyOnDisposal = new HashSet<IContextDisposalListener>();
    public static final String ACTIVE_CHILD = "activeChildContext";
    private static final IEclipseContextDebugger debugAddOn = ContextDebugHelper.getDebugger();

    public EclipseContext(IEclipseContext parent, ILookupStrategy strategy) {
        this.strategy = strategy;
        this.setParent(parent);
        if (parent == null) {
            this.waiting = Collections.synchronizedList(new ArrayList());
        }
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.CONSTRUCTED, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EclipseContext> getChildren() {
        if (this.children.size() == 0) {
            return null;
        }
        HashSet<EclipseContext> result = new HashSet<EclipseContext>(this.children.size());
        Set<WeakReference<EclipseContext>> set = this.children;
        synchronized (set) {
            Iterator<WeakReference<EclipseContext>> i = this.children.iterator();
            while (i.hasNext()) {
                EclipseContext referredContext = (EclipseContext)i.next().get();
                if (referredContext == null) {
                    i.remove();
                    continue;
                }
                result.add(referredContext);
            }
        }
        return result;
    }

    @Override
    public boolean containsKey(String name) {
        return this.containsKey(name, false);
    }

    public boolean containsKey(String name, boolean localOnly) {
        if (this.isSetLocally(name)) {
            return true;
        }
        if (localOnly) {
            return false;
        }
        EclipseContext parent = this.getParent();
        if (parent != null && parent.containsKey(name)) {
            return true;
        }
        return this.strategy != null && this.strategy.containsKey(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        EclipseContext[] currentChildren = null;
        Set<WeakReference<EclipseContext>> set = this.children;
        synchronized (set) {
            if (this.children.size() > 0) {
                HashSet<EclipseContext> localCopy = new HashSet<EclipseContext>(this.children.size());
                for (WeakReference<EclipseContext> weakReference : this.children) {
                    EclipseContext childContext = (EclipseContext)weakReference.get();
                    if (childContext == null) continue;
                    localCopy.add(childContext);
                }
                currentChildren = new EclipseContext[localCopy.size()];
                localCopy.toArray(currentChildren);
                this.children.clear();
            }
        }
        if (currentChildren != null) {
            EclipseContext[] eclipseContextArray = currentChildren;
            int n = currentChildren.length;
            int localCopy = 0;
            while (localCopy < n) {
                EclipseContext childContext = eclipseContextArray[localCopy];
                childContext.dispose();
                ++localCopy;
            }
        }
        ContextChangeEvent event = new ContextChangeEvent(this, 3, null, null, null);
        ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
        HashSet hashSet = new HashSet();
        for (Set set2 : this.listeners.values()) {
            hashSet.addAll(set2);
        }
        this.listeners.clear();
        for (Computation computation : hashSet) {
            computation.handleInvalid(event, scheduled);
        }
        this.processScheduled(scheduled);
        Set<IContextDisposalListener> set3 = this.notifyOnDisposal;
        synchronized (set3) {
            for (IContextDisposalListener listener : this.notifyOnDisposal) {
                listener.disposed(this);
            }
        }
        if (this.strategy != null) {
            this.strategy.dispose();
        }
        this.localValueComputations.clear();
        EclipseContext eclipseContext = this.getParent();
        if (eclipseContext != null && this == eclipseContext.getActiveChild()) {
            eclipseContext.set(ACTIVE_CHILD, null);
        }
        this.localValues.clear();
        if (eclipseContext != null) {
            eclipseContext.removeChild(this);
        }
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.DISPOSED, null);
        }
    }

    @Override
    public Object get(String name) {
        return this.internalGet(this, name, false);
    }

    @Override
    public Object getLocal(String name) {
        return this.internalGet(this, name, true);
    }

    public Object internalGet(EclipseContext originatingContext, String name, boolean local) {
        IEclipseContext parent;
        ValueComputation valueComputation;
        this.trackAccess(name);
        if (this == originatingContext && (valueComputation = this.localValueComputations.get(name)) != null) {
            return valueComputation.get();
        }
        Object result = null;
        if (this.localValues.containsKey(name)) {
            result = this.localValues.get(name);
            if (result == null) {
                return null;
            }
        } else if (this.strategy != null) {
            result = this.strategy.lookup(name, originatingContext);
        }
        if (result != null) {
            if (result instanceof IContextFunction) {
                ValueComputation valueComputation2 = new ValueComputation(this, originatingContext, name, (IContextFunction)result);
                originatingContext.localValueComputations.put(name, valueComputation2);
                EclipseContext step = originatingContext;
                while (step != null) {
                    valueComputation2.addDependency(step, name);
                    if (step == this) break;
                    valueComputation2.addDependency(step, PARENT);
                    step = step.getParent();
                }
                result = valueComputation2.get();
            }
            return result;
        }
        if (!local && (parent = (IEclipseContext)this.getLocal(PARENT)) != null) {
            return ((EclipseContext)parent).internalGet(originatingContext, name, local);
        }
        return null;
    }

    public void invalidate(String name, int eventType, Object oldValue, List<Scheduled> scheduled) {
        if (DebugHelper.DEBUG_NAMES) {
            System.out.println("[context] invalidating \"" + name + "\" on " + this.toString());
        }
        this.removeLocalValueComputations(name);
        this.handleInvalid(name, eventType, oldValue, scheduled);
    }

    void handleInvalid(String name, int eventType, Object oldValue, List<Scheduled> scheduled) {
        Set<Computation> computations = this.listeners.remove(name);
        if (computations == null) {
            return;
        }
        ContextChangeEvent event = new ContextChangeEvent(this, eventType, null, name, oldValue);
        for (Computation computation : computations) {
            computation.handleInvalid(event, scheduled);
        }
    }

    private boolean isSetLocally(String name) {
        this.trackAccess(name);
        return this.localValues.containsKey(name);
    }

    @Override
    public void remove(String name) {
        if (this.isSetLocally(name)) {
            Object oldValue = this.localValues.remove(name);
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            this.invalidate(name, 2, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalValueComputations(String name) {
        Map<String, ValueComputation> map = this.localValueComputations;
        synchronized (map) {
            ValueComputation removed = this.localValueComputations.remove(name);
            if (removed != null) {
                removed.stopListening(null, name);
            }
        }
    }

    @Override
    public void runAndTrack(RunAndTrack runnable) {
        ContextChangeEvent event = new ContextChangeEvent(this, 0, null, null, null);
        TrackableComputationExt computation = new TrackableComputationExt(runnable, this);
        computation.update(event);
    }

    protected void processScheduled(List<Scheduled> scheduledList) {
        HashSet<Scheduled> sent = new HashSet<Scheduled>(scheduledList.size());
        for (Scheduled scheduled : scheduledList) {
            if (!sent.add(scheduled)) continue;
            scheduled.runnable.update(scheduled.event);
        }
    }

    @Override
    public void set(String name, Object value) {
        if (DebugHelper.DEBUG_NAMES) {
            System.out.println("[context] set(" + name + ',' + value + ")" + " on " + this.toString());
        }
        if (PARENT.equals(name)) {
            this.setParent((IEclipseContext)value);
            return;
        }
        boolean containsKey = this.localValues.containsKey(name);
        Object oldValue = this.localValues.put(name, value);
        if (!containsKey || value != oldValue) {
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            this.invalidate(name, 1, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    @Override
    public void modify(String name, Object value) {
        ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
        if (!this.internalModify(name, value, scheduled)) {
            this.set(name, value);
        }
        this.processScheduled(scheduled);
    }

    public boolean internalModify(String name, Object value, List<Scheduled> scheduled) {
        boolean containsKey = this.localValues.containsKey(name);
        if (containsKey) {
            if (!this.checkModifiable(name)) {
                String tmp = "Variable " + name + " is not modifiable in the context " + this.toString();
                throw new IllegalArgumentException(tmp);
            }
            Object oldValue = this.localValues.put(name, value);
            if (value != oldValue) {
                this.invalidate(name, 1, oldValue, scheduled);
            }
            return true;
        }
        EclipseContext parent = this.getParent();
        if (parent != null) {
            return parent.internalModify(name, value, scheduled);
        }
        return false;
    }

    @Override
    public EclipseContext getParent() {
        this.trackAccess(PARENT);
        return (EclipseContext)this.localValues.get(PARENT);
    }

    @Override
    public void setParent(IEclipseContext parent) {
        EclipseContext parentContext = (EclipseContext)this.localValues.get(PARENT);
        if (parent == parentContext) {
            return;
        }
        if (parentContext != null) {
            parentContext.removeChild(this);
        }
        ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
        this.handleReparent((EclipseContext)parent, scheduled);
        this.localValues.put(PARENT, parent);
        if (parent != null) {
            ((EclipseContext)parent).addChild(this);
        }
        this.processScheduled(scheduled);
    }

    public String toString() {
        Object debugString = this.localValues.get(DEBUG_STRING);
        return debugString instanceof String ? (String)debugString : "Anonymous Context";
    }

    private void trackAccess(String name) {
        Computation computation = currentComputation.get();
        if (computation != null) {
            computation.addDependency(this, name);
        }
    }

    @Override
    public void declareModifiable(String name) {
        if (name == null) {
            return;
        }
        if (this.modifiable == null) {
            this.modifiable = new ArrayList(3);
        }
        this.modifiable.add(name);
        if (this.localValues.containsKey(name)) {
            return;
        }
        this.localValues.put(name, null);
    }

    private boolean checkModifiable(String name) {
        if (this.modifiable == null) {
            return false;
        }
        for (String candidate : this.modifiable) {
            if (!candidate.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeListenersTo(Object object) {
        Computation[] ls;
        if (object == null) {
            return;
        }
        ContextChangeEvent event = new ContextChangeEvent(this, 4, new Object[]{object}, null, null);
        Set<Computation> computations = this.getListeners();
        Computation[] computationArray = ls = computations.toArray(new Computation[computations.size()]);
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            Computation computation = computationArray[n2];
            if (computation instanceof TrackableComputationExt) {
                ((TrackableComputationExt)computation).update(event);
            }
            ++n2;
        }
    }

    private void handleReparent(EclipseContext newParent, List<Scheduled> scheduled) {
        this.processWaiting();
        Set<String> tmp = this.listeners.keySet();
        HashSet<String> usedNames = new HashSet<String>(tmp.size());
        usedNames.addAll(tmp);
        for (String name : usedNames) {
            Object newValue;
            if (this.localValues.containsKey(name)) continue;
            Object oldValue = this.get(name);
            Object object = newValue = newParent != null ? newParent.get(name) : null;
            if (oldValue == newValue) continue;
            this.invalidate(name, 1, oldValue, scheduled);
        }
        this.localValueComputations.clear();
    }

    @Override
    public void processWaiting() {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.processWaiting();
            return;
        }
        if (this.waiting == null) {
            return;
        }
        Computation[] ls = this.waiting.toArray(new Computation[this.waiting.size()]);
        this.waiting.clear();
        ContextChangeEvent event = new ContextChangeEvent(this, 5, null, null, null);
        int i = 0;
        while (i < ls.length) {
            if (ls[i] instanceof TrackableComputationExt) {
                ((TrackableComputationExt)ls[i]).update(event);
            }
            ++i;
        }
    }

    public void addWaiting(Computation cp) {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.addWaiting(cp);
            return;
        }
        if (this.waiting == null) {
            this.waiting = Collections.synchronizedList(new ArrayList());
        }
        this.waiting.add(cp);
    }

    protected EclipseContext getRoot() {
        EclipseContext root;
        EclipseContext current = this;
        do {
            root = current;
        } while ((current = current.getParent()) != null);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(EclipseContext childContext) {
        Set<WeakReference<EclipseContext>> set = this.children;
        synchronized (set) {
            this.children.add(new WeakReference<EclipseContext>(childContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(EclipseContext childContext) {
        Set<WeakReference<EclipseContext>> set = this.children;
        synchronized (set) {
            Iterator<WeakReference<EclipseContext>> i = this.children.iterator();
            while (i.hasNext()) {
                EclipseContext referredContext = (EclipseContext)i.next().get();
                if (referredContext == null) {
                    i.remove();
                    continue;
                }
                if (referredContext != childContext) continue;
                i.remove();
                return;
            }
        }
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.get(clazz.getName()));
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        return this.containsKey(clazz.getName());
    }

    @Override
    public <T> void set(Class<T> clazz, T value) {
        this.set(clazz.getName(), value);
    }

    @Override
    public void remove(Class<?> clazz) {
        this.remove(clazz.getName());
    }

    @Override
    public <T> T getLocal(Class<T> clazz) {
        return clazz.cast(this.getLocal(clazz.getName()));
    }

    @Override
    public <T> void modify(Class<T> clazz, T value) {
        this.modify(clazz.getName(), value);
    }

    @Override
    public void declareModifiable(Class<?> clazz) {
        this.declareModifiable(clazz.getName());
    }

    @Override
    public IEclipseContext createChild() {
        return new EclipseContext(this, null);
    }

    @Override
    public IEclipseContext createChild(String name) {
        IEclipseContext result = this.createChild();
        result.set(DEBUG_STRING, name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnDisposal(IContextDisposalListener listener) {
        Set<IContextDisposalListener> set = this.notifyOnDisposal;
        synchronized (set) {
            this.notifyOnDisposal.add(listener);
        }
    }

    public static ThreadLocal<Computation> localComputation() {
        return currentComputation;
    }

    @Override
    public IEclipseContext getActiveChild() {
        return (EclipseContext)this.internalGet(this, ACTIVE_CHILD, true);
    }

    @Override
    public IEclipseContext getActiveLeaf() {
        IEclipseContext activeContext = this;
        IEclipseContext child = this.getActiveChild();
        while (child != null) {
            activeContext = child;
            child = child.getActiveChild();
        }
        return activeContext;
    }

    @Override
    public void activate() {
        EclipseContext parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this == parent.getActiveChild()) {
            return;
        }
        parent.set(ACTIVE_CHILD, this);
    }

    @Override
    public void activateBranch() {
        IEclipseContext i = this;
        while (i != null) {
            i.activate();
            i = i.getParent();
        }
    }

    @Override
    public void deactivate() {
        EclipseContext parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this != parent.getActiveChild()) {
            return;
        }
        parent.set(ACTIVE_CHILD, null);
    }

    public Map<String, Object> localData() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValues.size());
        for (String string : this.localValues.keySet()) {
            Object value = this.localValues.get(string);
            if (value instanceof IContextFunction) continue;
            result.put(string, value);
        }
        return result;
    }

    public Map<String, Object> localContextFunction() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValues.size());
        for (String string : this.localValues.keySet()) {
            Object value = this.localValues.get(string);
            if (!(value instanceof IContextFunction)) continue;
            result.put(string, value);
        }
        return result;
    }

    public Map<String, Object> cachedCachedContextFunctions() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValueComputations.size());
        for (String string : this.localValueComputations.keySet()) {
            result.put(string, this.localValueComputations.get(string).get());
        }
        return result;
    }

    public Set<String> getRawListenerNames() {
        Set<String> tmp = this.listeners.keySet();
        HashSet<String> usedNames = new HashSet<String>(tmp.size());
        usedNames.addAll(tmp);
        return usedNames;
    }

    public Set<Computation> getListeners(String name) {
        Set<Computation> tmp = this.listeners.get(name);
        HashSet<Computation> result = new HashSet<Computation>(tmp.size());
        result.addAll(tmp);
        return result;
    }

    public void addListener(Computation computation, Set<String> names) {
        for (String name : names) {
            if (this.listeners.containsKey(name)) {
                Set<Computation> existingDependencies = this.listeners.get(name);
                existingDependencies.add(computation);
                continue;
            }
            HashSet<Computation> computations = new HashSet<Computation>();
            computations.add(computation);
            this.listeners.put(name, computations);
        }
    }

    public void removeListener(Computation computation) {
        for (Map.Entry<String, Set<Computation>> entry : this.listeners.entrySet()) {
            Set<Computation> computations = entry.getValue();
            computations.remove(computation);
        }
    }

    public Set<Computation> getListeners() {
        HashSet<Computation> computations = new HashSet<Computation>();
        for (Map.Entry<String, Set<Computation>> entry : this.listeners.entrySet()) {
            computations.addAll((Collection<Computation>)entry.getValue());
        }
        return computations;
    }

    static class Scheduled {
        public TrackableComputationExt runnable;
        public ContextChangeEvent event;

        public Scheduled(TrackableComputationExt runnable, ContextChangeEvent event) {
            this.runnable = runnable;
            this.event = event;
        }

        public int hashCode() {
            return 31 * (31 + this.event.hashCode()) + this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Scheduled other = (Scheduled)obj;
            if (!this.event.equals(other.event)) {
                return false;
            }
            return this.runnable.equals(other.runnable);
        }
    }
}

