/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.PreferenceWriter;
import org.osgi.framework.Bundle;

public class AboutServlet
extends HttpServlet {
    protected static final int NUMBER_OF_COLUMNS = 4;
    protected Locale locale;
    private static final long serialVersionUID = -1426745453574711075L;
    private static final String XHTML_1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>";
    private static final String XHTML_2 = "</title>\n <style type = \"text/css\"> td { padding-right : 10px; }</style></head>\n<body>\n";
    private static final String XHTML_3 = "</body>\n</html>";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html; charset=UTF-8");
        this.locale = UrlUtil.getLocaleObj(req, resp);
        StringBuffer buf = new StringBuffer();
        buf.append(XHTML_1);
        String showParam = req.getParameter("show");
        if ("agent".equalsIgnoreCase(showParam)) {
            this.getAgent(req, resp);
            return;
        }
        if ("preferences".equalsIgnoreCase(showParam)) {
            this.getPreferences(resp);
            return;
        }
        String sortParam = req.getParameter("sortColumn");
        int sortColumn = 3;
        if (sortParam != null) {
            try {
                sortColumn = Integer.parseInt(sortParam);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String title = WebappResources.getString("aboutPlugins", this.locale);
        buf.append(UrlUtil.htmlEncode(title));
        buf.append(XHTML_2);
        buf.append("<table>");
        ArrayList<Object> plugins = new ArrayList<Object>();
        Bundle[] bundles = HelpWebappPlugin.getContext().getBundles();
        int k = 0;
        while (k < bundles.length) {
            plugins.add(this.pluginDetails(bundles[k]));
            ++k;
        }
        PluginComparator pluginComparator = new PluginComparator(sortColumn);
        Collections.sort(plugins, pluginComparator);
        String[] headerColumns = new String[]{WebappResources.getString("provider", this.locale), WebappResources.getString("pluginName", this.locale), WebappResources.getString("version", this.locale), WebappResources.getString("pluginId", this.locale)};
        PluginDetails header = new PluginDetails(headerColumns);
        buf.append(this.headerRowFor(header));
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            PluginDetails details = (PluginDetails)iter.next();
            buf.append(this.tableRowFor(details));
        }
        buf.append("</table>");
        buf.append(XHTML_3);
        String response = buf.toString();
        resp.getWriter().write(response);
    }

    private void getPreferences(HttpServletResponse resp) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(XHTML_1);
        String title = WebappResources.getString("preferences", this.locale);
        buf.append(UrlUtil.htmlEncode(title));
        buf.append(XHTML_2);
        buf.append("<h1>");
        buf.append(title);
        buf.append("</h1>");
        PreferenceWriter writer = new PreferenceWriter(buf, this.locale);
        writer.writePreferences();
        buf.append(XHTML_3);
        String response = buf.toString();
        resp.getWriter().write(response);
    }

    private void getAgent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(XHTML_1);
        String title = WebappResources.getString("userAgent", this.locale);
        buf.append(UrlUtil.htmlEncode(title));
        buf.append(XHTML_2);
        buf.append("<h1>");
        buf.append(title);
        buf.append("</h1>");
        String agent = req.getHeader("User-Agent");
        buf.append(UrlUtil.htmlEncode(agent));
        buf.append(XHTML_3);
        String response = buf.toString();
        resp.getWriter().write(response);
    }

    private String headerRowFor(PluginDetails details) {
        String row = "<tr>\n";
        int i = 0;
        while (i < 4) {
            row = String.valueOf(row) + "<td><a href = \"about.html?sortColumn=";
            row = String.valueOf(row) + i;
            row = String.valueOf(row) + "\">";
            row = String.valueOf(row) + UrlUtil.htmlEncode(details.columns[i]);
            row = String.valueOf(row) + "</a></td>\n";
            ++i;
        }
        row = String.valueOf(row) + "</tr>";
        return row;
    }

    private String tableRowFor(PluginDetails details) {
        String row = "<tr>\n";
        int i = 0;
        while (i < 4) {
            row = String.valueOf(row) + "<td>";
            row = String.valueOf(row) + UrlUtil.htmlEncode(details.columns[i]);
            row = String.valueOf(row) + "</td>\n";
            ++i;
        }
        row = String.valueOf(row) + "</tr>";
        return row;
    }

    protected Object pluginDetails(Bundle bundle) {
        String[] values = new String[]{AboutServlet.getResourceString(bundle, "Bundle-Vendor"), AboutServlet.getResourceString(bundle, "Bundle-Name"), AboutServlet.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName()};
        PluginDetails details = new PluginDetails(values);
        return details;
    }

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = (String)bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    protected class PluginComparator
    implements Comparator {
        private int column;

        public PluginComparator(int column) {
            this.column = column;
        }

        public int compare(Object o1, Object o2) {
            PluginDetails pd1 = (PluginDetails)o1;
            PluginDetails pd2 = (PluginDetails)o2;
            return Collator.getInstance().compare(pd1.columns[this.column], pd2.columns[this.column]);
        }
    }

    protected class PluginDetails {
        public String[] columns = new String[4];

        public PluginDetails(String[] columns) {
            this.columns = columns;
            int i = 0;
            while (i < 4) {
                if (columns[i] == null) {
                    columns[i] = "";
                }
                ++i;
            }
        }
    }
}

