/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class ZipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public ZipLeveledStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
        this.stripLevel = 0;
    }

    protected ZipEntry createContainer(IPath pathname) {
        ZipEntry existingEntry = (ZipEntry)this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        ZipEntry newEntry = new ZipEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List parentChildList = (List)this.children.get(parent);
        parentChildList.add(newEntry);
        return newEntry;
    }

    protected void createFile(ZipEntry entry) {
        Path pathname = new Path(entry.getName());
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List childList = (List)this.children.get(parent);
        childList.add(entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.zipFile.getInputStream((ZipEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private String stripPath(String path) {
        String pathOrig = new String(path);
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    public String getFullPath(Object element) {
        return this.stripPath(((ZipEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((ZipEntry)element).getName();
        }
        return this.stripPath(new Path(((ZipEntry)element).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public boolean closeArchive() {
        try {
            this.getZipFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getZipFile().getName(), e);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            if (entry.isDirectory()) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((ZipEntry)element).isDirectory();
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

