/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardSourcePathProvider;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.VMHelper;

public class PDESourcePathProvider
extends StandardSourcePathProvider {
    public static final String ID = "org.eclipse.pde.ui.workbenchClasspathProvider";

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> sourcePath = new ArrayList<IRuntimeClasspathEntry>();
        sourcePath.add(this.getJREEntry(configuration));
        IProject[] projects = this.getJavaProjects(configuration);
        int i = 0;
        while (i < projects.length) {
            sourcePath.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)JavaCore.create((IProject)projects[i])));
            ++i;
        }
        return sourcePath.toArray(new IRuntimeClasspathEntry[sourcePath.size()]);
    }

    private IRuntimeClasspathEntry getJREEntry(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre = VMHelper.createLauncher(configuration);
        Path containerPath = new Path(JavaRuntime.JRE_CONTAINER);
        containerPath = containerPath.append(jre.getVMInstallType().getId());
        containerPath = containerPath.append(jre.getName());
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)containerPath, (int)2);
    }

    private IProject[] getJavaProjects(ILaunchConfiguration configuration) throws CoreException {
        IProject[] projects = LaunchPluginValidator.getAffectedProjects(configuration);
        return PDELaunchingPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getType() == 1) {
                all.add(entries[i]);
                IResource resource = entries[i].getResource();
                if (resource instanceof IProject) {
                    this.addBinaryPackageFragmentRoots(JavaCore.create((IProject)((IProject)resource)), all);
                }
            } else {
                IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entries[i], (ILaunchConfiguration)configuration);
                int j = 0;
                while (j < resolved.length) {
                    all.add(resolved[j]);
                    ++j;
                }
            }
            ++i;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    private void addBinaryPackageFragmentRoots(IJavaProject jProject, List all) throws CoreException {
        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
        int j = 0;
        while (j < roots.length) {
            if (roots[j].getKind() == 2 && !PDEJavaHelper.isJRELibrary((IPackageFragmentRoot)roots[j])) {
                IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)roots[j].getPath());
                IPath path = roots[j].getSourceAttachmentPath();
                if (path != null) {
                    rte.setSourceAttachmentPath(path);
                    rte.setSourceAttachmentRootPath(roots[j].getSourceAttachmentRootPath());
                }
                if (!all.contains(rte)) {
                    all.add(rte);
                }
            }
            ++j;
        }
    }
}

