/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalMethodReference;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class IllegalMethodReferenceDetector
extends AbstractIllegalMethodReference {
    public int getReferenceKinds() {
        return 1049536;
    }

    protected int getProblemKind() {
        return 3;
    }

    protected String getSeverityKey() {
        return "ILLEGAL_REFERENCE";
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        if (method.isConstructor()) {
            return new String[]{Signatures.getMethodSignature(method), this.getSimpleTypeName(reference.getMember())};
        }
        return new String[]{this.getSimpleTypeName(method), this.getSimpleTypeName(reference.getMember()), Signatures.getMethodSignature(method)};
    }

    protected Position getSourceRange(IType type, IDocument document, IReference reference) throws CoreException, BadLocationException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        Position pos = this.getMethodNameRange(method.isConstructor(), Signatures.getMethodName(method), document, reference);
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(method), this.getQualifiedTypeName(reference.getMember()), Signatures.getMethodSignature(method)};
    }
}

