/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;

public class SkippedComponent
implements IApiElement {
    private String componentid;
    private String version;
    private ResolverError[] errors = null;

    public SkippedComponent(String componentid, String version, ResolverError[] errors) {
        this.componentid = componentid;
        this.version = version;
        this.errors = errors;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SkippedComponent) {
            return this.componentid.equals(((SkippedComponent)obj).componentid);
        }
        return false;
    }

    public int hashCode() {
        return this.componentid.hashCode();
    }

    public String getComponentId() {
        return this.componentid;
    }

    public boolean wasExcluded() {
        return this.errors == null;
    }

    public boolean hasResolutionErrors() {
        return this.errors != null;
    }

    public IApiElement getAncestor(int ancestorType) {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public IApiComponent getApiComponent() {
        return null;
    }

    public String getName() {
        return this.componentid;
    }

    public IApiElement getParent() {
        return null;
    }

    public int getType() {
        return 1;
    }

    public ResolverError[] getErrors() {
        return this.errors;
    }

    private String[] resolveRootErrors(ResolverError[] errors) {
        TreeSet<String> collector = new TreeSet<String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo(o2);
            }
        });
        ResolverError error = null;
        VersionConstraint[] constraints = null;
        BundleDescription[] bundle = new BundleDescription[1];
        int i = 0;
        while (i < errors.length) {
            error = errors[i];
            if (error.getType() != 2) {
                collector.add(error.toString());
            }
            bundle[0] = error.getBundle();
            constraints = bundle[0].getContainingState().getStateHelper().getUnsatisfiedLeaves(bundle);
            if (constraints.length == 0) {
                collector.add(error.toString());
            }
            int j = 0;
            while (j < constraints.length) {
                collector.add(constraints[j].toString());
                ++j;
            }
            ++i;
        }
        return collector.toArray(new String[collector.size()]);
    }

    public String getErrorDetails() {
        if (this.errors != null) {
            StringBuffer buffer = new StringBuffer();
            String[] problems = this.resolveRootErrors(this.errors);
            int i = 0;
            while (i < problems.length) {
                buffer.append(problems[i]).append("<br/>");
                ++i;
            }
            return buffer.toString();
        }
        return SearchMessages.SkippedComponent_component_was_excluded;
    }
}

