/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.text.LineComparator;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorPart editor = EditorUtility.findEditor(inputElement, false);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null && (p = JavaPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorPart editor = EditorUtility.findEditor(inputElement, activate);
        if (editor != null) {
            return editor;
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_editorInput, 10008);
        }
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input), activate);
    }

    private static IEditorPart findEditor(Object inputElement, boolean activate) {
        ICompilationUnit cu;
        if (inputElement instanceof IJavaElement && (cu = (ICompilationUnit)((IJavaElement)inputElement).getAncestor(5)) != null) {
            boolean isCompareEditorInput;
            IEditorPart editor;
            IWorkbenchPage page = JavaPlugin.getActivePage();
            IEditorPart iEditorPart = editor = page != null ? (editor = page.getActiveEditor()) : null;
            if (editor != null && ((isCompareEditorInput = EditorUtility.isCompareEditorInput(editor.getEditorInput())) || !JavaModelUtil.isPrimary(cu))) {
                IEditorInput editorInput;
                if (isCompareEditorInput) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.IEditorInput");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    editorInput = (IEditorInput)editor.getAdapter((Class)clazz);
                } else {
                    editorInput = editor.getEditorInput();
                }
                ITypeRoot editorCU = EditorUtility.getEditorInputJavaElement(editorInput, false);
                if (cu.equals(editorCU)) {
                    if (activate && page.getActivePart() != editor) {
                        page.activate((IWorkbenchPart)editor);
                    }
                    return editor;
                }
            }
        }
        return null;
    }

    private static boolean isComparePlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.compare").getState() == 32;
    }

    public static boolean isCompareEditorInput(IEditorInput input) {
        return EditorUtility.isComparePlugInActivated() && JavaCompareUtilities.isCompareEditorInput(input);
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof JavaEditor) {
            ((JavaEditor)part).setSelection(element);
            return;
        }
        try {
            ISourceRange range = null;
            if (element instanceof ICompilationUnit) {
                return;
            }
            if (element instanceof IClassFile) {
                return;
            }
            if (element instanceof ILocalVariable) {
                range = ((ILocalVariable)element).getNameRange();
            } else if (element instanceof IMember) {
                range = ((IMember)element).getNameRange();
            } else if (element instanceof ITypeParameter) {
                range = ((ITypeParameter)element).getNameRange();
            } else if (element instanceof IAnnotation) {
                range = ((IAnnotation)element).getNameRange();
            } else if (element instanceof ISourceReference) {
                range = ((ISourceReference)element).getSourceRange();
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        IGotoMarker iGotoMarker;
        IGotoMarker gotoMarkerTarget;
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            gotoMarkerTarget = (IGotoMarker)editor;
        } else if (editor != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iGotoMarker = (IGotoMarker)editor.getAdapter((Class)clazz);
        } else {
            iGotoMarker = gotoMarkerTarget = null;
        }
        if (gotoMarkerTarget != null) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((p = JavaPlugin.getActivePage()) == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        EditorUtility.initializeHighlightRange(editorPart);
        return editorPart;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        Assert.isNotNull((Object)input);
        Assert.isNotNull((Object)editorID);
        IWorkbenchPage p = JavaPlugin.getActivePage();
        if (p == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart editorPart = p.openEditor(input, editorID, activate);
        EditorUtility.initializeHighlightRange(editorPart);
        return editorPart;
    }

    private static void throwPartInitException(String message, int code) throws PartInitException {
        Status status = new Status(4, "org.eclipse.jdt.ui", code, message, null);
        throw new PartInitException((IStatus)status);
    }

    private static void throwPartInitException(String message) throws PartInitException {
        EditorUtility.throwPartInitException(message, 0);
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (enable && editorPart instanceof JavaEditor) {
                enable = JavaPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.jdt.ui.editor.showSegments");
            } else {
                boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            }
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    public static String getEditorID(IEditorInput input) throws PartInitException {
        Assert.isNotNull((Object)input);
        IEditorDescriptor editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : IDE.getEditorDescriptor((String)input.getName());
        return editorDescriptor.getId();
    }

    public static ITypeRoot getEditorInputJavaElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        return EditorUtility.getEditorInputJavaElement(editor.getEditorInput(), primaryOnly);
    }

    private static ITypeRoot getEditorInputJavaElement(IEditorInput editorInput, boolean primaryOnly) {
        IJavaElement je;
        if (editorInput == null) {
            return null;
        }
        ICompilationUnit cu = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, primaryOnly);
        if (cu != null) {
            return cu;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)editorInput.getAdapter((Class)clazz)) instanceof ITypeRoot) {
            return (ITypeRoot)je;
        }
        return null;
    }

    private static IEditorInput getEditorInput(IJavaElement element) {
        while (element != null) {
            ICompilationUnit unit;
            IResource resource;
            if (element instanceof ICompilationUnit && (resource = (unit = ((ICompilationUnit)element).getPrimary()).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof IJavaElement) {
            return EditorUtility.getEditorInput((IJavaElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (JavaModelUtil.isOpenableStorage(input)) {
            return new JarEntryEditorInput((IStorage)input);
        }
        return null;
    }

    public static IJavaElement getActiveEditorJavaInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return JavaUI.getEditorInputJavaElement(editorInput);
        }
        return null;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(JavaEditorMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    public static IJavaProject getJavaProject(IEditorInput input) {
        IJavaProject jProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(jProject = JavaCore.create((IProject)project)).exists()) {
                jProject = null;
            }
        } else if (input instanceof IClassFileEditorInput) {
            jProject = ((IClassFileEditorInput)input).getClassFile().getJavaProject();
        }
        return jProject;
    }

    public static IEditorPart[] getDirtyEditors(boolean skipNonResourceEditors) {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.add(input) && (!skipNonResourceEditors || EditorUtility.isResourceEditorInput(input))) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static boolean isResourceEditorInput(IEditorInput input) {
        if (input instanceof MultiEditorInput) {
            IEditorInput[] inputs = ((MultiEditorInput)input).getInput();
            int i = 0;
            while (i < inputs.length) {
                IEditorInput iEditorInput = inputs[i];
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iEditorInput.getAdapter((Class)clazz) != null) {
                    return true;
                }
                ++i;
            }
        } else {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (input.getAdapter((Class)clazz) != null) {
                return true;
            }
        }
        return false;
    }

    public static IEditorPart[] getDirtyEditorsToSave(boolean saveUnknownEditors) {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (EditorUtility.mustSaveDirtyEditor(ep, input, saveUnknownEditors) && inputs.add(input)) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static boolean mustSaveDirtyEditor(IEditorPart ep, IEditorInput input, boolean saveUnknownEditors) {
        ICompilationUnit cu;
        IResource resource;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            return saveUnknownEditors;
        }
        IJavaElement javaElement = JavaCore.create((IResource)resource);
        if (javaElement instanceof ICompilationUnit && !(cu = (ICompilationUnit)javaElement).isWorkingCopy()) {
            return true;
        }
        if (!(ep instanceof ITextEditor)) {
            return saveUnknownEditors;
        }
        ITextEditor textEditor = (ITextEditor)ep;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (!(documentProvider instanceof TextFileDocumentProvider)) {
            return saveUnknownEditors;
        }
        return false;
    }

    public static IRegion[] calculateChangedLineRegions(final ITextFileBuffer buffer, final IProgressMonitor monitor) throws CoreException {
        final IRegion[][] result = new IRegion[1][];
        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
        try {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.ui", 10007, exception.getLocalizedMessage(), exception));
                    String msg = JavaEditorMessages.CompilationUnitDocumentProvider_error_calculatingChangedRegions;
                    errorStatus[0] = new Status(4, "org.eclipse.jdt.ui", 10007, msg, exception);
                    result[0] = null;
                }

                public void run() throws Exception {
                    monitor.beginTask(JavaEditorMessages.CompilationUnitDocumentProvider_calculatingChangedRegions_message, 20);
                    IFileStore fileStore = buffer.getFileStore();
                    ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
                    fileBufferManager.connectFileStore(fileStore, EditorUtility.getSubProgressMonitor(monitor, 15));
                    try {
                        IDocument currentDocument = buffer.getDocument();
                        IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                        result[0] = this.getChangedLineRegions(oldDocument, currentDocument);
                    }
                    finally {
                        fileBufferManager.disconnectFileStore(fileStore, EditorUtility.getSubProgressMonitor(monitor, 5));
                        monitor.done();
                    }
                }

                private IRegion[] getChangedLineRegions(IDocument oldDocument, IDocument currentDocument) throws BadLocationException {
                    LineComparator leftSide = new LineComparator(oldDocument);
                    LineComparator rightSide = new LineComparator(currentDocument);
                    RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
                    ArrayList<Object> regions = new ArrayList<Object>();
                    int i = 0;
                    while (i < differences.length) {
                        RangeDifference curr = differences[i];
                        if (curr.kind() == 2 && curr.rightLength() > 0) {
                            int startLine = curr.rightStart();
                            int endLine = curr.rightEnd() - 1;
                            IRegion startLineRegion = currentDocument.getLineInformation(startLine);
                            if (startLine == endLine) {
                                regions.add(startLineRegion);
                            } else {
                                IRegion endLineRegion = currentDocument.getLineInformation(endLine);
                                int startOffset = startLineRegion.getOffset();
                                int endOffset = endLineRegion.getOffset() + endLineRegion.getLength();
                                regions.add(new Region(startOffset, endOffset - startOffset));
                            }
                        }
                        ++i;
                    }
                    return regions.toArray(new IRegion[regions.size()]);
                }
            });
        }
        finally {
            if (!errorStatus[0].isOK()) {
                throw new CoreException(errorStatus[0]);
            }
        }
        return result[0];
    }

    private static IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }
}

