/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSTaskObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSParam;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.w3c.dom.Element;

public class CompCSTask
extends CompCSTaskObject
implements ICompCSTask {
    private ArrayList fFieldParams;
    private static final long serialVersionUID = 1L;

    public CompCSTask(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public List getChildren() {
        return new ArrayList();
    }

    public String getName() {
        return this.fFieldName;
    }

    public int getType() {
        return 2;
    }

    public String getElement() {
        return "task";
    }

    protected void parseElement(Element element) {
        super.parseElement(element);
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        if (name.equals("param")) {
            ICompCSParam param = factory.createCompCSParam(this);
            this.fFieldParams.add(param);
            param.parse(element);
        }
    }

    public void addFieldParam(ICompCSParam param) {
        this.fFieldParams.add(param);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)param, 1);
        }
    }

    public ICompCSParam[] getFieldParams() {
        return this.fFieldParams.toArray(new ICompCSParam[this.fFieldParams.size()]);
    }

    public void removeFieldParam(ICompCSParam param) {
        this.fFieldParams.remove(param);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)param, 2);
        }
    }

    public void reset() {
        super.reset();
        this.fFieldParams = new ArrayList();
    }

    protected void writeElements(String indent, PrintWriter writer) {
        super.writeElements(indent, writer);
        String newIndent = String.valueOf(indent) + "   ";
        Iterator iterator = this.fFieldParams.iterator();
        while (iterator.hasNext()) {
            ICompCSParam param = (ICompCSParam)iterator.next();
            param.write(newIndent, writer);
        }
    }

    public boolean hasFieldParams() {
        return !this.fFieldParams.isEmpty();
    }

    public ICompCSParam getFieldParam(String name) {
        if (this.fFieldParams.isEmpty()) {
            return null;
        }
        ListIterator iterator = this.fFieldParams.listIterator();
        while (iterator.hasNext()) {
            ICompCSParam parameter = (ICompCSParam)iterator.next();
            if (!parameter.getFieldName().equals(name)) continue;
            return parameter;
        }
        return null;
    }
}

