/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.expressions.LegacyEditorContributionExpression;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.menus.CommandContributionItem;

public class EditorMenuManager
extends SubMenuManager {
    private ArrayList wrappers;
    private boolean enabledAllowed = true;
    private Expression legacyActionBarExpression;
    private Overrides overrides = new Overrides();
    private MApplication application;
    private IWorkbenchWindow workbenchWindow;
    private String editorId;
    private static HashMap<IWorkbenchWindow, Map<String, ArrayList<MMenuContribution>>> menuContributions = new HashMap();
    private static HashMap<String, ArrayList<MenuManager>> managersToProcess = new HashMap();

    private Expression getExpression() {
        if (this.legacyActionBarExpression == null) {
            this.legacyActionBarExpression = new LegacyEditorContributionExpression(this.editorId, this.workbenchWindow);
        }
        return this.legacyActionBarExpression;
    }

    private MExpression createExpression() {
        MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
        exp.setCoreExpressionId("programmatic." + this.editorId);
        exp.setCoreExpression((Object)this.getExpression());
        return exp;
    }

    public EditorMenuManager(MApplication application, IWorkbenchWindow workbenchWindow, String editorId, IMenuManager mgr) {
        super(mgr);
        this.application = application;
        this.workbenchWindow = workbenchWindow;
        this.editorId = editorId;
    }

    public IContributionItem[] getItems() {
        return this.getParentMenuManager().getItems();
    }

    public IContributionManagerOverrides getOverrides() {
        return this.overrides;
    }

    private void add(MMenuContribution mc, IContributionItem item) {
        if (item instanceof MenuManager) {
            MenuManager menuManager = (MenuManager)item;
            this.addManagerToProcess(menuManager);
            MMenu subMenu = MenuHelper.createMenu(menuManager);
            if (subMenu != null) {
                mc.getChildren().add(subMenu);
            }
        } else if (item instanceof CommandContributionItem) {
            CommandContributionItem cci = (CommandContributionItem)item;
            MMenuItem menuItem = MenuHelper.createItem(this.application, cci);
            if (menuItem != null) {
                mc.getChildren().add(menuItem);
            }
        } else if (item instanceof ActionContributionItem) {
            MMenuItem menuItem = MenuHelper.createItem(this.application, (ActionContributionItem)item);
            if (menuItem != null) {
                mc.getChildren().add(menuItem);
            }
        } else if (item instanceof AbstractGroupMarker) {
            MMenuSeparator separator = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
            separator.setToBeRendered(item.isVisible());
            separator.setElementId(item.getId());
            mc.getChildren().add(separator);
        } else if (!(item instanceof SubContributionItem) && !(item instanceof SubMenuManager)) {
            MRenderedMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createRenderedMenuItem();
            menuItem.setContributionItem((Object)item);
            mc.getChildren().add(menuItem);
        }
    }

    public void insertAfter(String id, IContributionItem item) {
        MMenuContribution mc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mc.setParentId(this.getId());
        if (id != null && !id.equals(item.getId())) {
            mc.setPositionInParent("after=" + id);
        }
        mc.setVisibleWhen(this.createExpression());
        this.add(mc, item);
        this.addMenuContribution(mc, true);
        this.application.getMenuContributions().add(mc);
        super.insertAfter(id, item);
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        this.insertAfter(groupName, item);
    }

    public void insertBefore(String id, IContributionItem item) {
        MMenuContribution mc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mc.setParentId(this.getId());
        mc.setVisibleWhen(this.createExpression());
        if (id != null && !id.equals(item.getId())) {
            mc.setPositionInParent("before=" + id);
        }
        this.add(mc, item);
        this.addMenuContribution(mc, false);
        this.application.getMenuContributions().add(mc);
        super.insertBefore(id, item);
    }

    public void add(IContributionItem item) {
        String pos = "after=additions";
        IContributionItem[] items = this.getItems();
        if (items.length > 0) {
            int i = items.length;
            while (i > 0) {
                IContributionItem localItem = items[i - 1];
                if (localItem.getId() != null && !localItem.getId().equals(item.getId())) {
                    pos = "after=" + localItem.getId();
                    break;
                }
                --i;
            }
        }
        MMenuContribution mc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mc.setParentId(this.getId());
        mc.setPositionInParent(pos);
        mc.setVisibleWhen(this.createExpression());
        this.add(mc, item);
        this.addMenuContribution(mc, false);
        this.application.getMenuContributions().add(mc);
        super.add(item);
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        String pos = "after=" + groupName;
        IContributionItem[] items = this.getItems();
        boolean nextGroup = false;
        int i = 0;
        while (i < items.length) {
            IContributionItem localItem = items[i];
            if (groupName.equals(localItem.getId())) {
                nextGroup = true;
            }
            if ((localItem.isGroupMarker() || localItem.isSeparator()) && nextGroup && localItem.getId() != null && !localItem.getId().equals(item.getId())) {
                pos = "before=" + localItem.getId();
                break;
            }
            ++i;
        }
        MMenuContribution mc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mc.setParentId(this.getId());
        mc.setPositionInParent(pos);
        mc.setVisibleWhen(this.createExpression());
        this.add(mc, item);
        this.addMenuContribution(mc, false);
        this.application.getMenuContributions().add(mc);
        super.appendToGroup(groupName, item);
    }

    private void addMenuContribution(MMenuContribution mc, boolean insert) {
        ArrayList<Object> contributions;
        Map<String, ArrayList<MMenuContribution>> map = menuContributions.get(this.workbenchWindow);
        if (map == null) {
            map = new HashMap<String, ArrayList<MMenuContribution>>();
            menuContributions.put(this.workbenchWindow, map);
        }
        if ((contributions = map.get(this.editorId)) == null) {
            contributions = new ArrayList();
            map.put(this.editorId, contributions);
        }
        if (insert) {
            contributions.add(0, mc);
        } else {
            contributions.add(mc);
        }
    }

    private void addManagerToProcess(MenuManager manager) {
        ArrayList<Object> contributions = managersToProcess.get(this.editorId);
        if (contributions == null) {
            contributions = new ArrayList();
            managersToProcess.put(this.editorId, contributions);
        }
        contributions.add(manager);
    }

    public void setVisible(boolean visible, boolean forceVisibility) {
        if (visible) {
            if (forceVisibility) {
                if (!this.enabledAllowed) {
                    this.setEnabledAllowed(true);
                }
            } else if (this.enabledAllowed) {
                this.setEnabledAllowed(false);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (forceVisibility) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
    }

    public void setEnabledAllowed(boolean enabledAllowed) {
        if (this.enabledAllowed == enabledAllowed) {
            return;
        }
        this.enabledAllowed = enabledAllowed;
        this.overrides.updateEnabledAllowed();
    }

    protected SubMenuManager wrapMenu(IMenuManager menu) {
        if (this.wrappers == null) {
            this.wrappers = new ArrayList();
        }
        EditorMenuManager manager = new EditorMenuManager(this.application, this.workbenchWindow, this.editorId, menu);
        this.wrappers.add(manager);
        return manager;
    }

    protected IAction[] getAllContributedActions() {
        HashSet set = new HashSet();
        this.getAllContributedActions(set);
        return set.toArray(new IAction[set.size()]);
    }

    protected void getAllContributedActions(HashSet set) {
        IContributionItem[] items = super.getItems();
        int i = 0;
        while (i < items.length) {
            this.getAllContributedActions(set, items[i]);
            ++i;
        }
        if (this.wrappers == null) {
            return;
        }
        for (EditorMenuManager element : this.wrappers) {
            element.getAllContributedActions(set);
        }
    }

    protected void getAllContributedActions(HashSet set, IContributionItem item) {
        if (item instanceof MenuManager) {
            IContributionItem[] subItems = ((MenuManager)item).getItems();
            int j = 0;
            while (j < subItems.length) {
                this.getAllContributedActions(set, subItems[j]);
                ++j;
            }
        } else if (item instanceof ActionContributionItem) {
            set.add(((ActionContributionItem)item).getAction());
        }
    }

    public void disposeManager() {
        Map<String, ArrayList<MMenuContribution>> map = menuContributions.get(this.workbenchWindow);
        if (map != null) {
            ArrayList<MMenuContribution> contributions = map.remove(this.editorId);
            if (contributions != null) {
                this.application.getMenuContributions().removeAll(contributions);
            }
            if (map.isEmpty()) {
                menuContributions.remove(this.workbenchWindow);
            }
        }
        super.disposeManager();
    }

    public void processMenuManagers() {
        ArrayList<MenuManager> contributions = managersToProcess.remove(this.editorId);
        if (contributions == null) {
            return;
        }
        for (MenuManager manager : contributions) {
            this.processMenuManager(manager);
        }
        managersToProcess.remove(this.editorId);
    }

    private void processMenuManager(MenuManager manager) {
        if (manager.getId() == null) {
            return;
        }
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            return;
        }
        MMenuContribution mc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mc.setParentId(manager.getId());
        mc.setPositionInParent("after=additions");
        mc.setVisibleWhen(this.createExpression());
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            this.add(mc, item);
            if (item instanceof MenuManager) {
                this.processMenuManager((MenuManager)item);
            }
            ++n2;
        }
        this.addMenuContribution(mc, false);
        this.application.getMenuContributions().add(mc);
    }

    private class Overrides
    implements IContributionManagerOverrides {
        private Overrides() {
        }

        public void updateEnabledAllowed() {
            IContributionItem[] items = EditorMenuManager.super.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                item.update("enabled");
                ++i;
            }
            if (EditorMenuManager.this.wrappers != null) {
                i = 0;
                while (i < EditorMenuManager.this.wrappers.size()) {
                    EditorMenuManager manager = (EditorMenuManager)((Object)EditorMenuManager.this.wrappers.get(i));
                    manager.setEnabledAllowed(EditorMenuManager.this.enabledAllowed);
                    ++i;
                }
            }
        }

        public Boolean getEnabled(IContributionItem item) {
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() instanceof RetargetAction || EditorMenuManager.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public Integer getAccelerator(IContributionItem item) {
            if (this.getEnabled(item) == null) {
                return EditorMenuManager.this.getParentMenuManager().getOverrides().getAccelerator(item);
            }
            return new Integer(0);
        }

        public String getAcceleratorText(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getAcceleratorText(item);
        }

        public String getText(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getText(item);
        }

        public Boolean getVisible(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getVisible(item);
        }
    }
}

