/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableColumn;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableDependentTablePage
extends WizardPage {
    private static final String SELECT_THE_DEPENDENT_COLUMN_WHICH_WILL_BE_USED_DURING_GENERATION = Messages.TableDependentTablePage_SELECT_THE_DEPENDENT_COLUMN_WHICH_WILL_BE_USED_DURING_GENERATION;
    private static final String SELECT_DEPENDENT_COLUMN = Messages.TableDependentTablePage_SELECT_DEPENDENT_COLUMN;
    private static final Logger logger = Logger.getLogger(TableDependentTablePage.class);
    public static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.js.wizard.TableDependentTablePage";
    private JavascriptServiceTemplateModel model;
    private ComboViewer viewer;

    public ComboViewer getViewer() {
        return this.viewer;
    }

    protected TableDependentTablePage(JavascriptServiceTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(SELECT_DEPENDENT_COLUMN);
        this.setDescription(SELECT_THE_DEPENDENT_COLUMN_WHICH_WILL_BE_USED_DURING_GENERATION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createColumnsField(composite);
        this.checkPageStatus();
    }

    private void createColumnsField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(SELECT_DEPENDENT_COLUMN);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.viewer = new ComboViewer(parent, 8);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TableColumn) {
                    TableColumn current = (TableColumn)element;
                    return current.getName();
                }
                return super.getText(element);
            }
        });
        TableColumn[] columns = this.model.getTableColumns();
        this.viewer.setInput((Object)columns);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableColumn column = (TableColumn)selection.getFirstElement();
                TableDependentTablePage.this.model.setDependentColumn(column.getName());
                TableDependentTablePage.this.viewer.refresh();
                TableDependentTablePage.this.checkPageStatus();
            }
        });
    }

    private void checkPageStatus() {
        this.setPageComplete(this.model.validateDependentColumn());
    }
}

