/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.Messages;
import org.eclipse.dirigible.runtime.js.RepositoryModuleSourceProvider;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;

public class JavaScriptExecutor
extends AbstractScriptExecutor {
    private static final String REQUESTED_ENDPOINT_IS_NOT_A_SERVICE_BUT_RATHER_A_LIBRARY = "Requested endpoint is not a service, but rather a library.";
    private static final String EXPORTS_ERR = "\"exports\" is not defined";
    private static final String JAVA_SCRIPT_MODULE_NAME_CANNOT_BE_NULL = Messages.getString("JavaScriptExecutor.JAVA_SCRIPT_MODULE_NAME_CANNOT_BE_NULL");
    private static final Logger logger = Logger.getLogger(JavaScriptExecutor.class);
    private IRepository repository;
    private String[] rootPaths;

    public JavaScriptExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        logger.debug("entering: executeServiceModule()");
        logger.debug("module=" + module);
        if (module == null) {
            throw new IOException(JAVA_SCRIPT_MODULE_NAME_CANNOT_BE_NULL);
        }
        RepositoryModuleSourceProvider sourceProvider = this.createRepositoryModuleSourceProvider();
        SoftCachingModuleScriptProvider scriptProvider = new SoftCachingModuleScriptProvider((ModuleSourceProvider)sourceProvider);
        RequireBuilder builder = new RequireBuilder();
        builder.setModuleScriptProvider((ModuleScriptProvider)scriptProvider);
        builder.setSandboxed(false);
        Object result = null;
        Context context = Context.enter();
        try {
            context.setLanguageVersion(120);
            context.getWrapFactory().setJavaPrimitiveWrap(false);
            ScriptableObject topLevelScope = context.initStandardObjects();
            Require require = builder.createRequire(context, (Scriptable)topLevelScope);
            require.install((Scriptable)topLevelScope);
            this.registerDefaultVariables(request, response, input, executionContext, this.repository, topLevelScope);
            this.beforeExecution(request, response, module, context);
            try {
                ModuleSource moduleSource = sourceProvider.loadSource(module, null, null);
                try {
                    result = context.evaluateReader((Scriptable)topLevelScope, moduleSource.getReader(), module, 0, null);
                }
                catch (EcmaError e) {
                    if (e.getMessage() != null && e.getMessage().contains(EXPORTS_ERR)) {
                        result = REQUESTED_ENDPOINT_IS_NOT_A_SERVICE_BUT_RATHER_A_LIBRARY;
                    }
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            Context.exit();
        }
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    protected void beforeExecution(HttpServletRequest request, HttpServletResponse response, String module, Context context) {
    }

    private RepositoryModuleSourceProvider createRepositoryModuleSourceProvider() {
        RepositoryModuleSourceProvider repositoryModuleSourceProvider = null;
        repositoryModuleSourceProvider = new RepositoryModuleSourceProvider(this, this.repository, this.rootPaths);
        return repositoryModuleSourceProvider;
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
        if (scope instanceof ScriptableObject) {
            ScriptableObject local = (ScriptableObject)scope;
            local.put(name, (Scriptable)local, value);
        }
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

