/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IComparisonSideViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ComparisonSideViewer
extends TreeViewer
implements IComparisonSideViewer {
    private final boolean _sideIsLeft;

    public ComparisonSideViewer(Composite parent_p, boolean isLeftSide_p) {
        this(parent_p, 770, isLeftSide_p);
    }

    public ComparisonSideViewer(Composite parent_p, int style_p, boolean isLeftSide_p) {
        super(parent_p, style_p);
        this._sideIsLeft = isLeftSide_p;
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)super.getContentProvider();
    }

    public EMFDiffNode getInput() {
        return (EMFDiffNode)((Object)super.getInput());
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)super.getSelection();
    }

    public Color getSideColor() {
        return this.getInput() == null ? null : this.getInput().getDifferenceColor(this.isLeftSide() ? EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT : EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT);
    }

    protected Role getSideRole() {
        return this.getInput() == null ? null : this.getInput().getRoleForSide(this.isLeftSide());
    }

    public IModelScope getSideScope() {
        return this.getInput() == null ? null : this.getInput().getActualComparison().getScope(this.getInput().getRoleForSide(this.isLeftSide()));
    }

    public boolean isLeftSide() {
        return this._sideIsLeft;
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement_p) {
            IMatch match = (IMatch)parentElement_p;
            List result = ComparisonSideViewer.this.getInput().getActualComparison().getContentsOf(match, ComparisonSideViewer.this.getSideRole());
            return result.toArray();
        }

        public Object[] getElements(Object inputElement_p) {
            EMFDiffNode input = (EMFDiffNode)((Object)inputElement_p);
            List result = input.getActualComparison().getContents(ComparisonSideViewer.this.getSideRole());
            return result.toArray();
        }

        public Object getParent(Object element_p) {
            IMatch match = (IMatch)element_p;
            return ComparisonSideViewer.this.getInput().getActualComparison().getContainerOf(match, ComparisonSideViewer.this.getSideRole());
        }

        public boolean hasChildren(Object element_p) {
            return this.getChildren(element_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        protected LabelProvider() {
        }

        private EObject getElementToRepresent(IMatch match_p) {
            Role sideRole = ComparisonSideViewer.this.getSideRole();
            EObject result = match_p.getUncoveredRole() == sideRole ? match_p.get(sideRole.opposite()) : match_p.get(sideRole);
            return result;
        }

        public Color getForeground(Object element_p) {
            EMatch match = (EMatch)element_p;
            DifferenceKind kind = ComparisonSideViewer.this.getInput().getDifferenceKind((IMatch)match);
            Color result = !kind.isNeutral() ? ComparisonSideViewer.this.getSideColor() : ComparisonSideViewer.this.getInput().getDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind.NONE);
            return result;
        }

        public Image getImage(Object element_p) {
            IMatch match = (IMatch)element_p;
            Image result = this.getDelegate().getImage((Object)this.getElementToRepresent(match));
            return result;
        }

        public String getText(Object element_p) {
            IMatch match = (IMatch)element_p;
            String result = this.getDelegate().getText((Object)this.getElementToRepresent(match));
            return result;
        }
    }
}

