/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.EMFDiffMergePlugin;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchOperation
extends AbstractExpensiveOperation {
    private final IMatchPolicy _policy;
    private final IComparison _comparison;

    public MatchOperation(IComparison comparison_p, IMatchPolicy policy_p) {
        this._comparison = comparison_p;
        this._policy = policy_p;
    }

    protected Map<Comparable<?>, EObject> explore(Role role_p, boolean rememberIds_p) {
        Map<Comparable<Object>, Object> result = rememberIds_p ? new TreeMap() : Collections.emptyMap();
        IFeaturedModelScope scope = this._comparison.getScope(role_p);
        if (scope != null) {
            TreeIterator<EObject> it = scope.getAllContents();
            IMapping.Editable mapping = (IMapping.Editable)this._comparison.getMapping();
            while (it.hasNext()) {
                EObject squatter;
                Comparable<?> id;
                this.checkProgress();
                EObject current = (EObject)it.next();
                mapping.map(current, role_p);
                if (!rememberIds_p || (id = this.getMatchPolicy().getMatchId(current, scope)) == null || (squatter = result.put(id, current)) == null) continue;
                EMFDiffMergePlugin.getDefault().warn(String.valueOf(Messages.MatchBuilder_WarningDuplicateIDs) + id);
            }
        }
        return result;
    }

    protected Map<Comparable<?>, EObject> exploreAndMatch(Role role_p, Map<Comparable<?>, EObject> idRegistry1_p, Role secondaryRole1_p, Map<Comparable<?>, EObject> idRegistry2_p, Role secondaryRole2_p, boolean rememberId_p) {
        Map<Comparable<Object>, Object> result = rememberId_p ? new TreeMap() : Collections.emptyMap();
        IFeaturedModelScope scope = this._comparison.getScope(role_p);
        if (scope != null) {
            TreeIterator<EObject> targetIt = scope.getAllContents();
            IMapping.Editable mapping = (IMapping.Editable)this._comparison.getMapping();
            while (targetIt.hasNext()) {
                this.checkProgress();
                EObject current = (EObject)targetIt.next();
                EObject counterpart1 = null;
                EObject counterpart2 = null;
                Comparable<?> id = this.getMatchPolicy().getMatchId(current, scope);
                if (id != null) {
                    EObject squatter;
                    if (rememberId_p && (squatter = result.put(id, current)) != null) {
                        EMFDiffMergePlugin.getDefault().warn(String.valueOf(Messages.MatchBuilder_WarningDuplicateIDs) + id);
                    }
                    counterpart1 = idRegistry1_p.get(id);
                    EObject eObject = counterpart2 = idRegistry2_p != null ? idRegistry2_p.get(id) : null;
                }
                if (counterpart1 != null) {
                    mapping.mapIncrementally(current, role_p, counterpart1, secondaryRole1_p);
                }
                if (counterpart2 != null) {
                    mapping.mapIncrementally(current, role_p, counterpart2, secondaryRole2_p);
                }
                if (counterpart1 != null || counterpart2 != null) continue;
                mapping.map(current, role_p);
            }
        }
        return result;
    }

    protected IMatchPolicy getMatchPolicy() {
        return this._policy;
    }

    public IComparison getOutput() {
        return this._comparison;
    }

    @Override
    public String getOperationName() {
        return Messages.MatchBuilder_Task_Main;
    }

    @Override
    protected int getWorkAmount() {
        return this._comparison.isThreeWay() ? 5 : 6;
    }

    protected void match() {
        boolean threeWay = this._comparison.isThreeWay();
        this.getMonitor().subTask(Messages.MatchBuilder_Task_RegisteringIDs);
        Map<Comparable<?>, EObject> referenceIdRegistry = this.explore(Role.REFERENCE, true);
        this.getMonitor().worked(1);
        this.getMonitor().subTask(Messages.MatchBuilder_Task_MappingIDs);
        Map<Comparable<?>, EObject> targetIdRegistry = this.exploreAndMatch(Role.TARGET, referenceIdRegistry, Role.REFERENCE, null, null, threeWay);
        this.getMonitor().worked(1);
        if (threeWay) {
            this.exploreAndMatch(Role.ANCESTOR, referenceIdRegistry, Role.REFERENCE, targetIdRegistry, Role.TARGET, false);
            this.getMonitor().worked(1);
        }
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        this.match();
        IMapping.Editable mapping = (IMapping.Editable)this._comparison.getMapping();
        mapping.crossReference(Role.TARGET);
        this.getMonitor().worked(1);
        mapping.crossReference(Role.REFERENCE);
        this.getMonitor().worked(1);
        return Status.OK_STATUS;
    }
}

