/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.view;

import org.eclipse.datatools.sqltools.plan.IExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.IPlanDrawer;
import org.eclipse.datatools.sqltools.plan.IPlanParser;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanServiceRegistry;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExecutionPlansDrawer {
    private IExecutionPlanDocument[] _planDocs;
    private Combo _comboQuery;
    private ViewForm _planForm;
    private ScrolledComposite _scComposite;
    private Composite _graphicComposite;
    private Canvas _canvas;
    private IPlanDrawer _drawer;
    private Browser _browser;
    private static final int COMBO_ITEM_MAX_LEN = 90;
    private static final int TOOLTIP_BOX_WIDTH = 150;
    private SelectionListener _comboSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ExecutionPlansDrawer.this.drawPlan();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public ExecutionPlansDrawer(ViewForm planForm, Browser browser) {
        this._planForm = planForm;
        this._browser = browser;
        this.init();
    }

    private void init() {
        this._scComposite = new ScrolledComposite((Composite)this._planForm, 2816);
        this._scComposite.setLayout((Layout)new GridLayout());
        this._scComposite.setExpandHorizontal(true);
        this._scComposite.setExpandVertical(true);
        this._graphicComposite = new Composite((Composite)this._scComposite, 0);
        this._graphicComposite.setLayout((Layout)new GridLayout());
        this._graphicComposite.setLayoutData((Object)new GridData(1808));
        this._scComposite.setContent((Control)this._graphicComposite);
        this.createComboQuery(this._graphicComposite);
        this._canvas = new Canvas(this._graphicComposite, 0);
        this._canvas.setLayout((Layout)new GridLayout());
        this._canvas.setLayoutData((Object)new GridData(1808));
        this._planForm.setContent((Control)this._scComposite);
        this._scComposite.setMinSize(this._graphicComposite.computeSize(-1, -1));
    }

    private void createComboQuery(Composite parent) {
        GridData gridData11 = new GridData();
        this._comboQuery = new Combo(parent, 8);
        gridData11.grabExcessHorizontalSpace = true;
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        this._comboQuery.setLayoutData((Object)gridData11);
        this._comboQuery.addSelectionListener(this._comboSelectionListener);
        this._comboQuery.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                ExecutionPlansDrawer.this._comboQuery.setToolTipText(ExecutionPlansDrawer.this.addLineSeparator(ExecutionPlansDrawer.this._planDocs[ExecutionPlansDrawer.this._comboQuery.getSelectionIndex()].getName()));
            }
        });
    }

    private void drawPlan() {
        IExecutionPlanDocument doc = null;
        if (this._planDocs != null && this._planDocs.length > 1 && this._comboQuery.getSelectionIndex() >= 0) {
            doc = this._planDocs[this._comboQuery.getSelectionIndex()];
        } else if (this._planDocs != null && this._planDocs.length == 1) {
            doc = this._planDocs[0];
        }
        if (doc != null) {
            this._drawer.drawPlan(doc);
        }
        this._scComposite.setMinSize(this._graphicComposite.computeSize(-1, -1));
        this._scComposite.redraw();
    }

    private String addLineSeparator(String str) {
        StringBuffer sb = new StringBuffer("");
        int length = str.length();
        while (length > 150) {
            if (sb.toString().length() > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            int i = 150;
            while (i > 0) {
                if (str.charAt(i) == ',' || str.charAt(i) == ' ') break;
                --i;
            }
            sb.append(str.substring(0, i));
            str = str.substring(i);
            length = str.length();
        }
        if (sb.toString().length() > 0) {
            sb.append(System.getProperty("line.separator"));
        }
        sb.append(str);
        return sb.toString();
    }

    public void setPlan(IPlanInstance instance) {
        IPlanService planService = PlanServiceRegistry.getInstance().getPlanService(instance.getPlanRequest().getDatabaseDefinitionId());
        this._drawer = planService.getPlanDrawer();
        if (!this._graphicComposite.isDisposed()) {
            this._graphicComposite.dispose();
        }
        this._graphicComposite = new Composite((Composite)this._scComposite, 0);
        this._graphicComposite.setLayout((Layout)new GridLayout());
        this._graphicComposite.setLayoutData((Object)new GridData(1808));
        this._scComposite.setContent((Control)this._graphicComposite);
        this._canvas = new Canvas(this._graphicComposite, 0);
        this._canvas.setLayout((Layout)new GridLayout());
        this._canvas.setLayoutData((Object)new GridData(1808));
        this._drawer.setCanvas(this._canvas);
        this._drawer.setBrowser(this._browser);
        this._drawer.init();
        if (instance.getPlanDocuments() == null && instance.getRawPlan() != null) {
            IPlanParser parser = planService.getPlanParser();
            this._planDocs = parser.parsePlan(instance.getRawPlan());
            instance.setPlanDocuments(this._planDocs);
        }
        if (instance.getPlanDocuments() != null && instance.getPlanDocuments().length == 1) {
            this._canvas.setToolTipText(this.addLineSeparator(instance.getPlanDocuments()[0].getName()));
        }
        this._planDocs = instance.getPlanDocuments();
        if (this._planDocs != null && this._planDocs.length > 1) {
            if (this._comboQuery.isDisposed()) {
                this.createComboQuery(this._graphicComposite);
            }
            this._comboQuery.moveAbove(null);
            this._graphicComposite.layout(true);
            this._comboQuery.removeAll();
            int i = 0;
            while (i < this._planDocs.length) {
                String itemName = this._planDocs[i].getName();
                if (itemName != null && itemName.length() > 90) {
                    itemName = String.valueOf(itemName.substring(0, 90)) + "...";
                }
                this._comboQuery.add(itemName);
                ++i;
            }
            this._comboQuery.setVisibleItemCount(this._comboQuery.getItemCount() > 25 ? 25 : this._comboQuery.getItemCount());
            this._comboQuery.select(0);
        } else {
            if (!this._comboQuery.isDisposed()) {
                this._comboQuery.dispose();
            }
            this._canvas.moveAbove(null);
            this._graphicComposite.layout(true);
        }
        this.drawPlan();
    }
}

