/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class CaseControlledMultiLineRule
extends MultiLineRule {
    private boolean caseSensitive = false;
    private int singleQuotesCount = 0;
    private int doubleQuotesCount = 0;
    private int singleQuotes = 39;
    private int doubleQuotes = 34;
    private String[] fInnerStartBlocks = null;
    private String[] fInnerEndBlocks = null;
    private String[] fIncludeInnerBlockCommands = null;
    private String[] fInnerBlocksWithSameEnd = null;
    private int fSameInnerBlockCounter = 0;

    public CaseControlledMultiLineRule(String startSequence, String endSequence, IToken token) {
        super(startSequence, endSequence, token);
    }

    public CaseControlledMultiLineRule(String startSequence, String endSequence, IToken token, char escapeCharacter) {
        super(startSequence, endSequence, token, escapeCharacter);
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        boolean startCondition;
        int c = scanner.read();
        if (this.caseSensitive) {
            startCondition = c == this.fStartSequence[0];
        } else {
            boolean bl = startCondition = c == this.fStartSequence[0] || c == Character.toUpperCase(this.fStartSequence[0]);
        }
        if (startCondition) {
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        boolean esfCondition = false;
        boolean includeInnerBlock = false;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = this.readChar(scanner)) != -1) {
            if (c == this.fEscapeCharacter) {
                this.readChar(scanner);
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32) continue;
            if (!includeInnerBlock && this.fIncludeInnerBlockCommands != null) {
                boolean startCondition = false;
                int k = 0;
                while (k < this.fIncludeInnerBlockCommands.length) {
                    char tmpChar = this.fIncludeInnerBlockCommands[k].charAt(0);
                    if (this.caseSensitive) {
                        startCondition = c == tmpChar;
                    } else {
                        boolean bl = startCondition = c == tmpChar || c == Character.toUpperCase(tmpChar);
                    }
                    if (startCondition && this.sequenceDetected(scanner, this.fIncludeInnerBlockCommands[k].toCharArray(), false)) {
                        includeInnerBlock = true;
                        break;
                    }
                    ++k;
                }
                if (includeInnerBlock) continue;
            }
            if (this.fInnerStartBlocks != null && includeInnerBlock && this.fInnerStartBlocks.length == this.fInnerEndBlocks.length) {
                boolean blockStartCondition = false;
                boolean findBlock = false;
                int k = 0;
                while (k < this.fInnerStartBlocks.length) {
                    char tmpChar = this.fInnerStartBlocks[k].charAt(0);
                    if (this.caseSensitive) {
                        blockStartCondition = c == tmpChar;
                    } else {
                        boolean bl = blockStartCondition = c == tmpChar || c == Character.toUpperCase(tmpChar);
                    }
                    if (blockStartCondition && this.sequenceDetected(scanner, this.fInnerStartBlocks[k].toCharArray(), false)) {
                        if (this.fInnerStartBlocks[k].equalsIgnoreCase("DECLARE")) {
                            this.endDECLARESequenceDetected(scanner);
                        } else if (this.fInnerStartBlocks[k].equalsIgnoreCase("BEGIN")) {
                            this.endBEGINSequenceDetected(scanner);
                        } else {
                            this.endBlockSequenceDetected(scanner, this.fInnerEndBlocks[k].toCharArray());
                        }
                        findBlock = true;
                        break;
                    }
                    ++k;
                }
                if (findBlock) continue;
            }
            if (this.fEndSequence.length > 0) {
                if (this.caseSensitive) {
                    esfCondition = c == this.fEndSequence[0];
                } else {
                    boolean bl = esfCondition = c == this.fEndSequence[0] || c == Character.toUpperCase(this.fEndSequence[0]);
                }
            }
            if (esfCondition) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], false)) {
                    return true;
                }
                ++i;
            }
        }
        scanner.unread();
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        boolean startCondition;
        this.singleQuotesCount = 0;
        this.doubleQuotesCount = 0;
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner);
        }
        int c = scanner.read();
        scanner.unread();
        if (this.caseSensitive) {
            startCondition = c == this.fStartSequence[0];
        } else {
            boolean bl = startCondition = c == this.fStartSequence[0] || c == Character.toUpperCase(this.fStartSequence[0]);
        }
        if (startCondition) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        SQLWordDetector wDetector;
        char[] ucSequence = new char[sequence.length];
        if (!this.caseSensitive) {
            int i = 0;
            while (i < sequence.length) {
                ucSequence[i] = Character.toUpperCase(sequence[i]);
                ++i;
            }
        }
        int tsQC = this.singleQuotesCount;
        int tdQC = this.doubleQuotesCount;
        int c = -1;
        int i = 1;
        while (i < sequence.length) {
            boolean nmcCondition;
            c = scanner.read();
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.caseSensitive) {
                nmcCondition = c != sequence[i];
            } else {
                boolean bl = nmcCondition = c != sequence[i] && c != ucSequence[i];
            }
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (nmcCondition) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                this.singleQuotesCount = tsQC;
                this.doubleQuotesCount = tdQC;
                return false;
            }
            ++i;
        }
        if (c != -1 && (wDetector = new SQLWordDetector()).isWordPart((char)c)) {
            c = scanner.read();
            scanner.unread();
            if (wDetector.isWordPart((char)c)) {
                int j = sequence.length - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                this.singleQuotesCount = tsQC;
                this.doubleQuotesCount = tdQC;
                return false;
            }
        }
        return true;
    }

    public void setCaseSensitive(boolean csensitive) {
        this.caseSensitive = csensitive;
    }

    private boolean endBlockSequenceDetected(ICharacterScanner scanner, char[] sequence) {
        int c;
        boolean esfCondition = false;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = this.readChar(scanner)) != -1) {
            if (c == this.fEscapeCharacter) {
                this.readChar(scanner);
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32) continue;
            if (this.fInnerBlocksWithSameEnd != null) {
                boolean blockStartCondition = false;
                boolean findBlock = false;
                int k = 0;
                while (k < this.fInnerBlocksWithSameEnd.length) {
                    char tmpChar = this.fInnerBlocksWithSameEnd[k].charAt(0);
                    if (this.caseSensitive) {
                        blockStartCondition = c == tmpChar;
                    } else {
                        boolean bl = blockStartCondition = c == tmpChar || c == Character.toUpperCase(tmpChar);
                    }
                    if (blockStartCondition && this.sequenceDetected(scanner, this.fInnerBlocksWithSameEnd[k].toCharArray(), false)) {
                        this.endBlockSequenceDetected(scanner, sequence);
                        findBlock = true;
                        break;
                    }
                    ++k;
                }
                if (findBlock) continue;
            }
            if (sequence.length > 0) {
                if (this.caseSensitive) {
                    esfCondition = c == sequence[0];
                } else {
                    boolean bl = esfCondition = c == sequence[0] || c == Character.toUpperCase(sequence[0]);
                }
            }
            if (esfCondition) {
                if (!this.sequenceDetected(scanner, sequence, true)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], false)) {
                    return true;
                }
                ++i;
            }
        }
        scanner.unread();
        return true;
    }

    public void setInnerBlocksStartSequence(String[] aNew) {
        this.fInnerStartBlocks = aNew;
    }

    public void setInnerBlocksEndSequence(String[] aNew) {
        this.fInnerEndBlocks = aNew;
    }

    public void setIncludeInnerBlockCommands(String[] aNew) {
        this.fIncludeInnerBlockCommands = aNew;
    }

    public void setInnerBlocksWithSameEndSequence(String[] aNew) {
        this.fInnerBlocksWithSameEnd = aNew;
    }

    private boolean endBEGINSequenceDetected(ICharacterScanner scanner) {
        int c;
        boolean esfCondition = false;
        char[][] specialEnds = new char[][]{{'i', 'f'}, {'w', 'h', 'i', 'l', 'e'}, {'f', 'o', 'r'}, {'l', 'o', 'o', 'p'}, {'c', 'a', 's', 'e'}, {'r', 'e', 'p', 'e', 'a', 't'}};
        char[] endSequence = new char[]{'e', 'n', 'd'};
        SQLWordDetector wDetector = new SQLWordDetector();
        while ((c = this.readChar(scanner)) != -1) {
            if (c == this.fEscapeCharacter) {
                this.readChar(scanner);
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32) continue;
            if (endSequence.length > 0) {
                if (this.caseSensitive) {
                    esfCondition = c == endSequence[0];
                } else {
                    boolean bl = esfCondition = c == endSequence[0] || c == Character.toUpperCase(endSequence[0]);
                }
            }
            if (esfCondition && this.sequenceDetected(scanner, endSequence, true) && this.checkNextToken(scanner, specialEnds)) {
                if (this.fSameInnerBlockCounter <= 0) {
                    return true;
                }
                --this.fSameInnerBlockCounter;
            }
            if (!wDetector.isWordPart((char)c)) continue;
            scanner.unread();
            char[] endCommandSqeuence = new char[]{';'};
            char[] startCommandSequence = new char[]{'b', 'e', 'g', 'i', 'n'};
            this.endSQLCommandSequenceDetected(scanner, endCommandSqeuence, startCommandSequence);
        }
        scanner.unread();
        return true;
    }

    private boolean endDECLARESequenceDetected(ICharacterScanner scanner) {
        int c;
        boolean condition = false;
        char[] beginSequence = new char[]{'b', 'e', 'g', 'i', 'n'};
        SQLWordDetector wDetector = new SQLWordDetector();
        while ((c = this.readChar(scanner)) != -1) {
            if (c == this.fEscapeCharacter) {
                this.readChar(scanner);
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32) continue;
            if (this.caseSensitive) {
                condition = c == beginSequence[0];
            } else {
                boolean bl = condition = c == beginSequence[0] || c == Character.toUpperCase(beginSequence[0]);
            }
            if (condition && this.sequenceDetected(scanner, beginSequence, true)) {
                this.endBEGINSequenceDetected(scanner);
                return true;
            }
            if (!wDetector.isWordPart((char)c)) continue;
            scanner.unread();
            char[] endCommandSqeuence = new char[]{';'};
            char[] startCommandSequence = new char[]{};
            this.endSQLCommandSequenceDetected(scanner, endCommandSqeuence, startCommandSequence);
        }
        scanner.unread();
        return true;
    }

    protected boolean endSQLCommandSequenceDetected(ICharacterScanner scanner, char[] endSequence, char[] innerBlock) {
        int c;
        boolean tmpCondition = false;
        while ((c = this.readChar(scanner)) != -1) {
            if (c == this.fEscapeCharacter) {
                this.readChar(scanner);
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32) continue;
            if (innerBlock.length > 0) {
                if (this.caseSensitive) {
                    tmpCondition = c == innerBlock[0];
                } else {
                    boolean bl = tmpCondition = c == innerBlock[0] || c == Character.toUpperCase(innerBlock[0]);
                }
            }
            if (tmpCondition && this.sequenceDetected(scanner, innerBlock, true)) {
                ++this.fSameInnerBlockCounter;
            }
            if (endSequence.length > 0) {
                if (this.caseSensitive) {
                    tmpCondition = c == endSequence[0];
                } else {
                    boolean bl = tmpCondition = c == endSequence[0] || c == Character.toUpperCase(endSequence[0]);
                }
            }
            if (!tmpCondition || !this.sequenceDetected(scanner, endSequence, true)) continue;
            return true;
        }
        scanner.unread();
        return true;
    }

    private boolean checkNextToken(ICharacterScanner scanner, char[][] skipSequence) {
        int c;
        int k = 0;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            ++k;
            if (c == this.fEscapeCharacter) {
                scanner.read();
                ++k;
                continue;
            }
            if (c == this.singleQuotes && this.doubleQuotesCount == 0) {
                this.singleQuotesCount = 1 - this.singleQuotesCount;
            } else if (c == this.doubleQuotes && this.singleQuotesCount == 0) {
                this.doubleQuotesCount = 1 - this.doubleQuotesCount;
            }
            if (this.singleQuotesCount != 0 || this.doubleQuotesCount != 0 || c == 32 || c == 9) continue;
            boolean isEndOfLine = false;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], false)) {
                    isEndOfLine = true;
                    break;
                }
                ++i;
            }
            if (isEndOfLine) continue;
            boolean condition = false;
            int i2 = 0;
            while (i2 < skipSequence.length) {
                if (this.caseSensitive) {
                    condition = c == skipSequence[i2][0];
                } else {
                    boolean bl = condition = c == skipSequence[i2][0] || c == Character.toUpperCase(skipSequence[i2][0]);
                }
                if (condition) {
                    if (this.sequenceDetected(scanner, skipSequence[i2], false)) {
                        int j = skipSequence[i2].length - 1;
                        while (j > 0) {
                            scanner.unread();
                            --j;
                        }
                        break;
                    }
                    condition = false;
                }
                ++i2;
            }
            if (condition) break;
            i2 = 0;
            while (i2 < k - 1) {
                scanner.unread();
                ++i2;
            }
            scanner.unread();
            return true;
        }
        int i = 0;
        while (i < k - 1) {
            scanner.unread();
            ++i;
        }
        scanner.unread();
        return false;
    }

    /*
     * Exception decompiling
     */
    private int readChar(ICharacterScanner scanner) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

