/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultConfiguration;
import org.eclipse.datatools.sqltools.result.ResultSetObject;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;

public class ResultInstanceFactory {
    public static ResultInstanceFactory INSTANCE = new ResultInstanceFactory();

    private ResultInstanceFactory() {
    }

    public IResultInstance createNewInstance(OperationCommand cmd, Runnable terminateHandler) {
        return this.createNewInstance(cmd, terminateHandler, null);
    }

    public IResultInstance createNewInstance(OperationCommand cmd, Runnable terminateHandler, IResultInstance parentInstance) {
        if (cmd == null || cmd.getDisplayString() == null) {
            return null;
        }
        IResultManager resultManager = ResultsViewAPI.getInstance().getResultManager();
        IResultInstance instance = ResultsViewAPI.getInstance().getResultInstance(cmd);
        if (instance == null) {
            instance = new ResultInstance(resultManager, cmd, terminateHandler, parentInstance);
            resultManager.fireAdded(instance);
        }
        return instance;
    }

    public IResultSetObject createResultSetObject(ResultSet resultset) throws SQLException {
        ResultSetObject r = new ResultSetObject(resultset, ResultConfiguration.getInstance().getMaxRowCount(), ResultConfiguration.getInstance().getMaxDisplayRowCount(), ResultConfiguration.getInstance().isShowLabel());
        return r;
    }
}

