/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileRenameChange
extends ConnectionProfileChange {
    private RenameArguments mRenameArguments;

    public String getName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPRenameChange.name"), this.mSource.getName());
    }

    public ConnectionProfileRenameChange(IConnectionProfile source, RenameArguments args) {
        super(source, null);
        this.mRenameArguments = args;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.renameProfile(pm));
        return undo;
    }

    private Change renameProfile(IProgressMonitor pm) {
        Shell shell = new Shell();
        String oldName = this.mSource.getName();
        RenameArguments oldArgs = new RenameArguments(oldName, true);
        try {
            ProfileManager.getInstance().modifyProfile(this.mSource, this.mRenameArguments.getNewName(), this.mSource.getDescription());
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException(shell, ConnectivityUIPlugin.getDefault().getResourceString("CPRenameChange.title.error"), e.getLocalizedMessage(), e);
            return new NullChange();
        }
        return new ConnectionProfileRenameChange(this.mSource, oldArgs);
    }
}

