/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.catalog.IngresCatalogTrigger;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;

public class IngresTableTriggerLoader
extends JDBCBaseLoader {
    private static final String TRIGGER_QUERY = "SELECT DISTINCT rule_name, rule_owner, system_use, table_name FROM iirules WHERE table_name = ? AND rule_owner = ? AND system_use='U' ORDER BY rule_name";
    private static final String TRIGGER_NAME = "rule_name";

    public IngresTableTriggerLoader() {
        this(null);
    }

    public IngresTableTriggerLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresTableTriggerLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadTriggers(List containmentList, List existingTriggers) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.getCatalogObject().getConnection().prepareStatement(TRIGGER_QUERY);
            rs = this.createResultSet(stmt);
            String triggerName = null;
            while (rs.next()) {
                triggerName = rs.getString(TRIGGER_NAME).trim();
                Trigger trigger = (Trigger)this.getAndRemoveSQLObject(existingTriggers, triggerName);
                if (trigger == null) {
                    trigger = this.processRow(rs);
                    if (trigger == null) continue;
                    containmentList.add(trigger);
                    continue;
                }
                containmentList.add(trigger);
                if (!(trigger instanceof ICatalogObject)) continue;
                ((ICatalogObject)trigger).refresh();
            }
        }
        catch (Throwable throwable) {
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
            throw throwable;
        }
        LoaderHelper.close(rs);
        LoaderHelper.close(stmt);
    }

    public void clearTriggers(List existingTriggers) {
        existingTriggers.clear();
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            String table = ((Table)this.getCatalogObject()).getName();
            String schema = ((Table)this.getCatalogObject()).getSchema().getName();
            stmt.setString(1, table);
            stmt.setString(2, schema);
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (sequences)");
            error.initCause(e);
            throw error;
        }
    }

    protected Trigger processRow(ResultSet rs) throws SQLException {
        Trigger trigger = this.createTrigger();
        this.initialize(trigger, rs);
        return trigger;
    }

    protected void initialize(Trigger trigger, ResultSet rs) throws SQLException {
        String triggerName = rs.getString(TRIGGER_NAME).trim();
        trigger.setName(triggerName);
        trigger.setSchema(((Table)this.getCatalogObject()).getSchema());
    }

    protected Trigger createTrigger() {
        return new IngresCatalogTrigger();
    }
}

