/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.catalog.ICatalogAuthorizationIdentifier;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogRole;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWServerCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.ModuleCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.StorageProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWContainerType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabaseContainer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabasePartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.WrapperType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWDatabaseImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LUWCatalogDatabase
extends LUWDatabaseImpl
implements ICatalogObject {
    private static StorageProvider storageCatalogProvider = null;
    private static Vector luwserverProviders = null;
    private static ModuleCatalogProvider moduleCatalogPovider = null;
    protected Connection connection;
    private boolean schemasLoaded = false;
    private boolean wrappersLoaded = false;
    private boolean remoteServersLoaded = false;
    private boolean partitionGroupLoaded = false;
    private boolean bufferpoolLoaded = false;
    private boolean tablespaceLoades = false;
    private boolean authLoaded = false;
    private boolean privilegeLoaded = false;
    private HashMap cachedSchema = new HashMap();
    private HashMap cachedAuth = new HashMap();
    private FilterListener filterListener = null;
    private Map<String, List<LUWDatabaseContainer>> cachedContainer = null;
    private boolean propertyLoaded = false;
    private boolean containerLoaded = false;

    public static StorageProvider getCatalogStorageProvider() {
        IExtension[] extensions;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "luwstorageProvider");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length == 1) {
            IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
            try {
                storageCatalogProvider = (StorageProvider)configElements[0].createExecutableExtension("class");
            }
            catch (Exception exception) {}
        }
        return storageCatalogProvider;
    }

    public static Vector getLUWServerCatalogProvider() {
        Vector<LUWServerCatalogProvider> providers = new Vector<LUWServerCatalogProvider>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "luwserverProvider");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("provider")) {
                        try {
                            LUWServerCatalogProvider provider = (LUWServerCatalogProvider)configElements[j].createExecutableExtension("class");
                            providers.add(provider);
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the LUWServer provider", (Throwable)e);
                            RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        luwserverProviders = providers;
        return luwserverProviders;
    }

    public static ModuleCatalogProvider getCatalogModuleProvider() {
        IExtension[] extensions;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "moduleProvider");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length == 1) {
            IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
            try {
                moduleCatalogPovider = (ModuleCatalogProvider)configElements[0].createExecutableExtension("class");
            }
            catch (Exception exception) {}
        }
        return moduleCatalogPovider;
    }

    public LUWCatalogDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public synchronized void refresh() {
        this.schemasLoaded = false;
        this.partitionGroupLoaded = false;
        this.bufferpoolLoaded = false;
        this.wrappersLoaded = false;
        this.remoteServersLoaded = false;
        this.tablespaceLoades = false;
        this.authLoaded = false;
        this.privilegeLoaded = false;
        this.propertyLoaded = false;
        this.containerLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public EList getSchemas() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getSchemas();
        }
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    @Override
    public EList getServers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getServers();
        }
        if (!this.remoteServersLoaded) {
            this.loadRemoteServers();
        }
        return this.servers;
    }

    @Override
    public EList getWrappers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getWrappers();
        }
        if (!this.wrappersLoaded) {
            this.loadWrappers();
        }
        return super.getWrappers();
    }

    @Override
    public boolean isFederated() {
        if (!this.remoteServersLoaded) {
            this.loadRemoteServers();
        }
        return this.federated;
    }

    @Override
    public EList getGroups() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getGroups();
        }
        if (!this.partitionGroupLoaded) {
            this.loadPartitionGroups();
        }
        return this.groups;
    }

    @Override
    public EList getBufferpools() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getBufferpools();
        }
        if (!this.bufferpoolLoaded) {
            this.loadBufferPools();
        }
        return this.bufferpools;
    }

    @Override
    public EList getTablespaces() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getTablespaces();
        }
        if (!this.tablespaceLoades) {
            this.loadTablespaces();
        }
        return this.tablespaces;
    }

    public EList getAuthorizationIds() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getAuthorizationIds();
        }
        if (!this.authLoaded) {
            this.loadAuthorizationIds();
        }
        return this.authorizationIds;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public boolean isPartitioned() {
        if (!this.propertyLoaded) {
            this.loadProperties();
        }
        return this.partitioned;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getSchemas();
        } else if (id == 19) {
            this.getServers();
        } else if (id == 16) {
            this.getServers();
        } else if (id == 17) {
            this.getGroups();
        } else if (id == 23) {
            this.getBufferpools();
        } else if (id == 18) {
            this.getWrappers();
        } else if (id == 13) {
            this.getAuthorizationIds();
        } else if (id == 7) {
            this.getPrivileges();
        } else if (id == 14) {
            this.isPartitioned();
        }
        if (this.filterListener == null) {
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            this.filterListener = new FilterListener(this);
            connectionInfo.addFilterListener((ConnectionFilterListener)this.filterListener);
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        this.schemasLoaded = true;
        this.registerFilterListener();
        EList schemaList = super.getSchemas();
        schemaList.clear();
        this.iniCachedSchema();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            ConnectionFilter filter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsSchemaFilterPredicate");
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
            }
            String query = "SELECT SCHEMANAME, REMARKS, OWNER FROM SYSCAT.SCHEMATA";
            if (filter != null) {
                query = String.valueOf(query) + " WHERE " + CatalogLoadUtil.getFilterString((String)filter.getPredicate(), (String)"rtrim(SCHEMANAME)");
            }
            query = String.valueOf(query) + " ORDER BY SCHEMANAME";
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String schemaName = r.getString(1).trim();
                String remarks = r.getString(2);
                LUWCatalogSchema schema = new LUWCatalogSchema();
                schema.setName(schemaName);
                schema.setDescription(remarks);
                String owner = r.getString(3).trim();
                AuthorizationIdentifier authid = LUWCatalogDatabase.getAuthorizationId((Database)this, owner, "U");
                schema.setOwner(authid);
                schemaList.add((Object)schema);
                this.cacheSchema((Schema)schema);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadRemoteServers() {
        if (this.remoteServersLoaded) {
            return;
        }
        this.remoteServersLoaded = true;
        this.registerFilterListener();
        EList remoteServerList = super.getServers();
        remoteServerList.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            this.loadLUWServers(remoteServerList, this);
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            ConnectionFilter filter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsRemoteServerFilterPredicate");
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsRemoteServerFilterPredicate");
            }
            String query = "SELECT s.SERVERNAME, s.SERVERTYPE, s.SERVERVERSION, s.REMARKS, s.WRAPNAME  FROM SYSCAT.SERVERS s, SYSCAT.WRAPPERS w WHERE s.WRAPNAME = w.WRAPNAME AND w.WRAPTYPE='R'";
            if (filter != null) {
                query = String.valueOf(query) + " AND " + CatalogLoadUtil.getFilterString((String)filter.getPredicate(), (String)"SERVERNAME");
            }
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String serverName = r.getString(1);
                    String serverType = r.getString(2);
                    String serverVersion = r.getString(3);
                    String remarks = r.getString(4);
                    String wrapperName = r.getString(5);
                    LUWCatalogFederatedServer server = new LUWCatalogFederatedServer();
                    server.setName(serverName);
                    server.setServerType(serverType);
                    server.setServerVersion(serverVersion);
                    server.setDescription(remarks);
                    server.setWrapperName(wrapperName);
                    remoteServerList.add((Object)server);
                }
                this.federated = true;
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPartitionGroups() {
        if (this.partitionGroupLoaded) {
            return;
        }
        this.partitionGroupLoaded = true;
        this.registerFilterListener();
        EList groupList = super.getGroups();
        groupList.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            StorageProvider provider = LUWCatalogDatabase.getCatalogStorageProvider();
            if (provider != null) {
                for (LUWPartitionGroup pg : provider.getPartitionGroups(this)) {
                    groupList.add((Object)pg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadBufferPools() {
        if (this.bufferpoolLoaded) {
            return;
        }
        this.bufferpoolLoaded = true;
        this.registerFilterListener();
        EList bpList = super.getBufferpools();
        bpList.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            StorageProvider provider = LUWCatalogDatabase.getCatalogStorageProvider();
            if (provider != null) {
                for (LUWBufferPool bp : provider.getBufferPools(this)) {
                    bpList.add((Object)bp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTablespaces() {
        if (this.tablespaceLoades) {
            return;
        }
        this.tablespaceLoades = true;
        this.registerFilterListener();
        super.getTablespaces().clear();
        this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            for (LUWPartitionGroup pg : this.getGroups()) {
                pg.getTableSpaces();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadAuthorizationIds() {
        if (this.authLoaded) {
            return;
        }
        this.authLoaded = true;
        this.registerFilterListener();
        EList authList = super.getAuthorizationIds();
        authList.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            this.cachedAuth.clear();
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)this);
            String version = definition.getVersion();
            float ver = 9.1f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            String query = "";
            query = (double)ver < 9.1 ? "SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.DBAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.SCHEMAAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.TABAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.PACKAGEAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.INDEXAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.COLAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.SEQUENCEAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.ROUTINEAUTH UNION SELECT DISTINCT GRANTEE AS AUTHID, GRANTEETYPE AS AUTHIDTYPE,'' AS REMARKS FROM SYSCAT.PASSTHRUAUTH ORDER BY AUTHID" : ((double)ver < 9.5 ? "SELECT DISTINCT AUTHID,AUTHIDTYPE,'' AS REMARKS  FROM SYSIBMADM.AUTHORIZATIONIDS" : "SELECT DISTINCT AUTHID,AUTHIDTYPE,'' AS REMARKS FROM SYSIBMADM.AUTHORIZATIONIDS UNION SELECT DISTINCT ROLENAME AS AUTHID,'R' AS AUTHIDTYPE, REMARKS FROM SYSCAT.ROLES");
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String authid = r.getString("AUTHID").trim();
                String authtype = r.getString("AUTHIDTYPE");
                ICatalogAuthorizationIdentifier auth = null;
                if ("G".equals(authtype)) {
                    auth = new LUWCatalogGroup();
                } else if ("U".equals(authtype)) {
                    auth = new LUWCatalogUser();
                } else {
                    if (!"R".equals(authtype)) continue;
                    auth = (AuthorizationIdentifier)this.cachedAuth.get(String.valueOf(authid) + ":" + authtype);
                    if (auth == null || !(auth instanceof Role)) {
                        auth = new LUWCatalogRole();
                    }
                }
                auth.setName(authid);
                String remarks = r.getString("REMARKS");
                auth.setDescription(remarks);
                authList.add((Object)auth);
                String authkey = String.valueOf(authid) + ":" + authtype;
                this.cachedAuth.put(authkey, auth);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        this.registerFilterListener();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList privileges = super.getPrivileges();
            for (Privilege privilege : privileges) {
                privilege.setGrantor(null);
                privilege.setGrantee(null);
            }
            privileges.clear();
            LUWCatalogDatabase.loadPrivileges(this.connection, super.getPrivileges(), (Database)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadLUWServers(EList serverList, LUWCatalogDatabase db) {
        Vector providers = LUWCatalogDatabase.getLUWServerCatalogProvider();
        int i = 0;
        while (i < providers.size()) {
            LUWServerCatalogProvider provider = (LUWServerCatalogProvider)providers.elementAt(i);
            for (LUWServer luwserver : provider.getLUWServers(db)) {
                serverList.add((Object)luwserver);
            }
            ++i;
        }
    }

    private synchronized void loadWrappers() {
        if (this.wrappersLoaded) {
            return;
        }
        this.wrappersLoaded = true;
        this.registerFilterListener();
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        super.getWrappers().clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogDatabase.loadWrappers(this.getConnection(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadProperties() {
        if (this.propertyLoaded) {
            return;
        }
        this.propertyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT COUNT(*) FROM TABLE(DB_PARTITIONS()) AS T";
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                int num = r.getInt(1);
                this.partitioned = num > 1;
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadWrappers(Connection connection, LUWDatabase database) throws SQLException {
        EList wrappersList = database.getWrappers();
        try {
            DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)database);
            String query = "SELECT WRAPNAME, WRAPTYPE, WRAPVERSION, LIBRARY, REMARKS FROM SYSCAT.WRAPPERS";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String name = r.getString("WRAPNAME");
                    String type = r.getString("WRAPTYPE");
                    String version = r.getString("WRAPVERSION");
                    String library = r.getString("LIBRARY");
                    String description = r.getString("REMARKS");
                    LUWCatalogWrapper wrapper = new LUWCatalogWrapper();
                    int iType = type.equals("R") ? 0 : 1;
                    WrapperType wrapperType = WrapperType.get(iType);
                    wrapper.setName(name);
                    wrapper.setWrapperType(wrapperType);
                    wrapper.setVersion(version);
                    wrapper.setLibrary(library);
                    wrapper.setDescription(description);
                    wrappersList.add((Object)wrapper);
                }
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadPrivileges(Connection connection, EList privileges, Database database, String granteeFilter) throws SQLException {
        try {
            int options = ((LUWCatalogDatabase)database).getLoadOptions();
            if ((options & 0x800) == 2048) {
                return;
            }
            Statement s = connection.createStatement();
            String query = "";
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            String version = definition.getVersion();
            float ver = 9.5f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            query = (double)ver < 9.1 ? "SELECT GRANTOR,GRANTEE,GRANTEETYPE,DBADMAUTH,CREATETABAUTH,BINDADDAUTH,CONNECTAUTH,NOFENCEAUTH,IMPLSCHEMAAUTH,LOADAUTH,EXTERNALROUTINEAUTH,QUIESCECONNECTAUTH,'N' AS SECURITYADMAUTH FROM SYSCAT.DBAUTH" : "SELECT GRANTOR,GRANTEE,GRANTEETYPE,DBADMAUTH,CREATETABAUTH,BINDADDAUTH,CONNECTAUTH,NOFENCEAUTH,IMPLSCHEMAAUTH,LOADAUTH,EXTERNALROUTINEAUTH,QUIESCECONNECTAUTH,SECURITYADMAUTH FROM SYSCAT.DBAUTH";
            if (granteeFilter != null && !"".equals(granteeFilter)) {
                query = String.valueOf(query) + " WHERE " + granteeFilter;
            }
            ResultSet r = s.executeQuery(query);
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                LUWCatalogPrivilege privilege = null;
                SQLAccessControlPackage.eINSTANCE.getPrivilege();
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                String auth = r.getString("DBADMAUTH");
                if (!auth.equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("DBADM");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("CREATETABAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CREATETAB");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("BINDADDAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("BINDADD");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("CONNECTAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CONNECT");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("NOFENCEAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CREATE_NOT_FENCED_ROUTINE");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("IMPLSCHEMAAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("IMPLICIT_SCHEMA");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("LOADAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("LOAD");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("EXTERNALROUTINEAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CREATE_EXTERNAL_ROUTINE");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(auth = r.getString("QUIESCECONNECTAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("QUIESCE_CONNECT");
                    privileges.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if ((auth = r.getString("SECURITYADMAUTH")).equals("N")) continue;
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("SECADM");
                privileges.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isBatchLoad() {
        try {
            for (EAnnotation eAnnotation : this.getEAnnotations()) {
                String source = eAnnotation.getSource();
                if (source == null || !source.equals("LOAD_PROPERTY")) continue;
                String batchLoadStr = (String)eAnnotation.getDetails().get((Object)"BATCH_LOAD");
                return new Boolean(batchLoadStr);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public int getLoadOptions() {
        try {
            for (EAnnotation eAnnotation : this.getEAnnotations()) {
                String source = eAnnotation.getSource();
                if (source == null || !source.equals("LOAD_PROPERTY")) continue;
                String loadOption = (String)eAnnotation.getDetails().get((Object)"LOAD_OPTIONS");
                return new Integer(loadOption);
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public Collection getDatabaseContainer(String tablespaceName) {
        if (!this.containerLoaded || this.cachedContainer == null) {
            this.cachedContainer = new HashMap<String, List<LUWDatabaseContainer>>();
            this.containerLoaded = true;
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)this);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            try {
                String query = "select distinct TABLESPACE_NAME, CONTAINER_NAME, CONTAINER_TYPE, TOTAL_PAGES   from TABLE (SYSPROC.SNAPSHOT_CONTAINER ( '' , -2)) AS S";
                Statement s = this.connection.createStatement();
                ResultSet r = s.executeQuery(query);
                while (r.next()) {
                    ArrayList list;
                    LUWDatabaseContainer container = (LUWDatabaseContainer)factory.create(LUWPackage.eINSTANCE.getLUWDatabaseContainer());
                    String tspName = r.getString("TABLESPACE_NAME").trim();
                    String name = r.getString("CONTAINER_NAME").trim();
                    container.setName(name);
                    int containerType = r.getInt("CONTAINER_TYPE");
                    if (containerType == 0) {
                        container.setContainerType(LUWContainerType.DIRECTORY_LITERAL);
                    } else if (containerType == 1 || containerType == 5) {
                        container.setContainerType(LUWContainerType.DEVICE_LITERAL);
                    } else {
                        container.setContainerType(LUWContainerType.FILE_LITERAL);
                    }
                    container.setSizeInPages(r.getInt("TOTAL_PAGES"));
                    if (!this.cachedContainer.containsKey(tspName)) {
                        list = new ArrayList();
                        list.add(container);
                        this.cachedContainer.put(tspName, list);
                        continue;
                    }
                    list = (ArrayList)this.cachedContainer.get(tspName);
                    list.add(container);
                }
                r.close();
                s.close();
                this.loadContainerPartitions();
            }
            catch (SQLException sQLException) {}
        }
        return (ArrayList)this.cachedContainer.get(tablespaceName);
    }

    private void loadContainerPartitions() throws SQLException {
        HashMap<Integer, LUWDatabasePartition> partnmap = new HashMap<Integer, LUWDatabasePartition>();
        EList pgroups = this.getGroups();
        for (Object o : pgroups) {
            LUWPartitionGroup pgroup = (LUWPartitionGroup)o;
            if (!pgroup.getName().equals("IBMDEFAULTGROUP")) continue;
            for (Object p : pgroup.getPartitions()) {
                LUWDatabasePartition partn = (LUWDatabasePartition)p;
                partnmap.put(partn.getNumber(), partn);
            }
        }
        Map<Integer, Collection<String>> tbspmap = this.getTablespacePartitionMap();
        if (tbspmap.isEmpty()) {
            return;
        }
        for (Integer pnum : tbspmap.keySet()) {
            String query = "select TABLESPACE_NAME, CONTAINER_NAME  from TABLE (SYSPROC.SNAPSHOT_CONTAINER ( '' , " + pnum.toString() + ")) AS S" + " order by TABLESPACE_NAME";
            LUWDatabasePartition partn = (LUWDatabasePartition)partnmap.get(pnum);
            if (partn == null) continue;
            try {
                Statement s = this.connection.createStatement();
                ResultSet r = s.executeQuery(query);
                while (r.next()) {
                    String cname = r.getString("CONTAINER_NAME").trim();
                    String tsname = r.getString("TABLESPACE_NAME").trim();
                    List<LUWDatabaseContainer> containers = this.cachedContainer.get(tsname);
                    if (containers == null) continue;
                    for (LUWDatabaseContainer container : containers) {
                        if (!container.getName().equals(cname)) continue;
                        container.getPartitions().add((Object)partn);
                    }
                }
                r.close();
                s.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private Map<Integer, Collection<String>> getTablespacePartitionMap() throws SQLException {
        String query = "select DBPARTITIONNUM, TBSP_NAME from SYSIBMADM.SNAPTBSP_PART order by DBPARTITIONNUM";
        Statement s = this.connection.createStatement();
        ResultSet r = s.executeQuery(query);
        HashMap<Integer, Collection<String>> pmap = new HashMap<Integer, Collection<String>>();
        try {
            int curpartnum = -1;
            ArrayList<String> names = null;
            while (r.next()) {
                int pnum = r.getInt("DBPARTITIONNUM");
                String tsname = r.getString("TBSP_NAME").trim();
                if (pnum != curpartnum) {
                    curpartnum = pnum;
                    names = new ArrayList<String>();
                    pmap.put(new Integer(pnum), names);
                }
                names.add(tsname);
            }
        }
        catch (SQLException sQLException) {}
        r.close();
        s.close();
        return pmap;
    }

    public Schema getSchema(String schemaName) {
        if (!this.schemasLoaded) {
            this.getSchemas();
        }
        return (Schema)this.cachedSchema.get(schemaName);
    }

    protected void cacheSchema(Schema schema) {
        this.cachedSchema.put(schema.getName(), schema);
    }

    private void iniCachedSchema() {
        this.cachedSchema = new HashMap();
    }

    private AuthorizationIdentifier getAuthId(String authId) {
        if (!this.authLoaded) {
            this.getAuthorizationIds();
        }
        return (AuthorizationIdentifier)this.cachedAuth.get(authId);
    }

    private AuthorizationIdentifier getAuthId(String authId, String authType) {
        if (!this.authLoaded) {
            this.getAuthorizationIds();
        }
        if (authType == null) {
            return (AuthorizationIdentifier)this.cachedAuth.get(authId);
        }
        String authkey = String.valueOf(authId) + ":" + authType;
        return (AuthorizationIdentifier)this.cachedAuth.get(authkey);
    }

    private void cacheAuth(AuthorizationIdentifier authId) {
        this.cachedAuth.put(authId.getName(), authId);
    }

    private void iniCachedAuth() {
        this.cachedAuth = new HashMap();
    }

    public static AuthorizationIdentifier getAuthorizationId(Database db, String name, String type) {
        Object auth2 = null;
        if (db instanceof LUWCatalogDatabase && (auth2 = type == null ? ((LUWCatalogDatabase)db).getAuthId(name) : ((LUWCatalogDatabase)db).getAuthId(name, type)) != null) {
            if ("G".equals(type) && auth2 instanceof Group) {
                return auth2;
            }
            if ("U".equals(type) && auth2 instanceof User) {
                return auth2;
            }
            if ("R".equals(type) && auth2 instanceof Role) {
                return auth2;
            }
            return auth2;
        }
        for (Object auth2 : db.getAuthorizationIds()) {
            if (!auth2.getName().equals(name)) continue;
            if ("G".equals(type) && auth2 instanceof Group) {
                return auth2;
            }
            if ("U".equals(type) && auth2 instanceof User) {
                return auth2;
            }
            if ("R".equals(type) && auth2 instanceof Role) {
                return auth2;
            }
            return auth2;
        }
        if ("G".equals(type)) {
            auth2 = new LUWCatalogGroup();
        } else if ("U".equals(type)) {
            auth2 = new LUWCatalogUser();
        } else if ("R".equals(type)) {
            auth2 = new LUWCatalogRole();
        }
        auth2.setName(name);
        auth2.setDatabase(db);
        return auth2;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogDatabase.loadPrivileges(this.connection, privileges, (Database)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private void registerFilterListener() {
        if (this.filterListener == null) {
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            this.filterListener = new FilterListener(this);
            connectionInfo.addFilterListener((ConnectionFilterListener)this.filterListener);
        }
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private LUWCatalogDatabase db;

        FilterListener(LUWCatalogDatabase db) {
            this.db = db;
        }

        public void connectionFilterAdded(String filterKey) {
            this.handleFilterUpdate(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            this.handleFilterUpdate(filterKey);
        }

        private void handleFilterUpdate(String filterKey) {
            if (filterKey.indexOf("DatatoolsSchemaFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsNicknameFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsRemoteServerFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsRemoteServerFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsTablespaceFilterPredicate") >= 0) {
                this.db.refresh();
            } else if (filterKey.indexOf("DatatoolsTableFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsViewFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsAliasFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsMQTFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsSequenceFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsSPFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsUDFFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsUDTFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsModuleFilterPredicate") >= 0 || filterKey.indexOf("DatatoolsPlsqlPacakgeFilterPredicate") >= 0) {
                if (filterKey.indexOf("::") > 0) {
                    ICatalogObject schema = (ICatalogObject)this.db.getSchema(filterKey.substring(0, filterKey.indexOf("::")));
                    if (schema != null) {
                        schema.refresh();
                    }
                } else {
                    this.db.refresh();
                }
            }
        }
    }
}

