/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.internal.dbitem;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.EngineeringOptionID;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.core.dbitem.ISPUDF;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sql.util.ParameterUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.emf.ecore.EObject;

public class SQLObjectItem
implements IDBItem,
IItemWithCode,
ISPUDF {
    protected ProcIdentifier _proc = null;
    protected SQLObject _routine = null;
    protected IControlConnection _controlConn = null;
    protected ParameterDescriptor[] _parameterDescriptors = null;

    public SQLObjectItem(ProcIdentifier proc, SQLObject routine, IControlConnection controlConn) {
        this._proc = proc;
        this._routine = routine;
        this._controlConn = controlConn;
    }

    public ProcIdentifier getProcIdentifier() {
        return this._proc;
    }

    public IControlConnection getControlConnection() {
        return this._controlConn;
    }

    public void refresh() {
        this.dispose();
    }

    public void dispose() {
        this._parameterDescriptors = null;
    }

    public String getCode() throws SQLException {
        String code = "";
        Database database = ModelUtil.getDatabase(ModelUtil.getSchema((EObject)this._routine));
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database.getVendor(), database.getVersion());
        DDLGenerator ddlg = databaseDefinition.getDDLGenerator();
        if (ddlg != null) {
            SQLObject[] sqlElements = new SQLObject[]{this._routine};
            EngineeringOption[] opts = ddlg.getOptions(sqlElements);
            boolean quotedId = SQLDevToolsUtil.getQuotedIdentifier(this._proc.getDatabaseIdentifier());
            EngineeringOptionID.setOptionValueByID((String)"GENERATE_QUOTED_IDENTIFIER", (EngineeringOption[])opts, (boolean)quotedId);
            String[] ddl = ddlg.generateDDL(sqlElements, null);
            if (ddl != null && ddl.length > 0) {
                code = ddl[0];
            }
        }
        return code;
    }

    public void save(String code) throws SQLException {
        DDLGenerator ddlg = ProfileUtil.getDatabaseDefinition(this._proc.getProfileName()).getDDLGenerator();
        if (ddlg != null) {
            SQLObject[] sqlElements = new SQLObject[]{this._routine};
            EngineeringOption[] opts = ddlg.getOptions(sqlElements);
            String[] drop = ddlg.dropSQLObjects(sqlElements, EngineeringOptionID.getOptionValueByID((String)"GENERATE_QUOTED_IDENTIFIER", (EngineeringOption[])opts), true, null);
            String[] ddl = new String[]{drop[0], code};
            this._controlConn.executeDDL(ddl);
        }
    }

    public void drop() throws SQLException {
        DDLGenerator ddlg = ProfileUtil.getDatabaseDefinition(this._proc.getProfileName()).getDDLGenerator();
        if (ddlg != null) {
            SQLObject[] sqlElements = new SQLObject[]{this._routine};
            ddlg.getOptions(sqlElements);
            String[] drop = ddlg.dropSQLObjects(sqlElements, SQLDevToolsUtil.isQuotedIdentifierOn(this._proc.getDatabaseIdentifier()), true, null);
            this._controlConn.executeDDL(drop);
        }
    }

    public int getValidBreakpointLocation(int number) throws SQLException {
        return number;
    }

    public ParameterDescriptor[] getParameterDescriptor() throws SQLException {
        if (this._parameterDescriptors == null && this._routine instanceof Routine) {
            Connection conn = null;
            conn = this.getConnection();
            this._parameterDescriptors = ParameterUtil.getParameterDescriptors(this.getControlConnection().getDatabaseIdentifier(), conn, this.getProcIdentifier().getType(), this.getProcIdentifier());
            String sql = this.getCode();
            Map defaultparamvalue = this.getParameterDefalutValues(sql);
            Map typeNames = this.getSPParamTypeNameMapFromParser(sql);
            if (this._parameterDescriptors != null) {
                int i = 0;
                while (i < this._parameterDescriptors.length) {
                    ParameterDescriptor param = this._parameterDescriptors[i];
                    String typeName = (String)typeNames.get(param.getName());
                    if (typeName != null) {
                        param.setSqlTypeNameFromParser(typeName);
                    }
                    if (defaultparamvalue != null) {
                        String value = (String)defaultparamvalue.get(param.getName());
                        if (value != null) {
                            if (SQLUtil.isStringType((int)param.getSqlDataType())) {
                                param.setDefaultValue(SQLUtil.unquote((String)value));
                            } else {
                                param.setDefaultValue(value);
                            }
                        } else if (this._routine instanceof Routine) {
                            Routine r = (Routine)this._routine;
                            if (SQLUtil.isNumericType((int)param.getSqlDataType()) && "JAVA".equalsIgnoreCase(r.getLanguage())) {
                                param.setDefaultValue("0");
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        if (this._parameterDescriptors == null) {
            this._parameterDescriptors = new ParameterDescriptor[0];
        }
        return this._parameterDescriptors;
    }

    public Map getParameterDefalutValues(String sql) throws SQLException {
        if (sql != null && !"".equals(sql.trim())) {
            Map prameterValueMap = ParameterUtil.getSPParamDefaultValues(this.getControlConnection().getDatabaseIdentifier(), sql);
            return prameterValueMap;
        }
        return new HashMap();
    }

    public Map getSPParamTypeNameMapFromParser(String sql) throws SQLException {
        if (sql != null && !"".equals(sql.trim())) {
            Map typeNames = ParameterUtil.getSPParamTypeNameMapFromParser(this.getControlConnection().getDatabaseIdentifier(), sql);
            return typeNames;
        }
        return new HashMap();
    }

    protected Connection getConnection() {
        return this._controlConn.getReusableConnection();
    }
}

