/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.utilities;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class InterfaceUtilities {
    public static List<RecordTypeDecl> getRecordTypes(Signature s) {
        ArrayList<RecordTypeDecl> _xblockexpression = null;
        ArrayList<RecordTypeDecl> recordTypes = new ArrayList<RecordTypeDecl>();
        Iterables.addAll(recordTypes, (Iterable)Iterables.filter(s.getTypes(), RecordTypeDecl.class));
        _xblockexpression = recordTypes;
        return _xblockexpression;
    }

    public static List<InterfaceEvent> getAllInterfaceEvents(Signature s) {
        ArrayList<InterfaceEvent> _xblockexpression = null;
        ArrayList<InterfaceEvent> events = new ArrayList<InterfaceEvent>();
        events.addAll((Collection<InterfaceEvent>)s.getCommands());
        events.addAll((Collection<InterfaceEvent>)s.getNotifications());
        events.addAll((Collection<InterfaceEvent>)s.getSignals());
        _xblockexpression = events;
        return _xblockexpression;
    }

    public static InterfaceEvent getInterfaceEventByName(String name, Signature s) {
        List<InterfaceEvent> _allInterfaceEvents = InterfaceUtilities.getAllInterfaceEvents(s);
        for (InterfaceEvent e : _allInterfaceEvents) {
            boolean _equals = e.getName().equals(name);
            if (!_equals) continue;
            return e;
        }
        return null;
    }

    public static List<InterfaceEvent> getCommandsAndSignals(Signature s) {
        ArrayList<InterfaceEvent> _xblockexpression = null;
        ArrayList<InterfaceEvent> result = new ArrayList<InterfaceEvent>();
        result.addAll((Collection<InterfaceEvent>)s.getCommands());
        result.addAll((Collection<InterfaceEvent>)s.getSignals());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static boolean usesMaps(Signature s) {
        Functions.Function1<InterfaceEvent, Boolean> _function = new Functions.Function1<InterfaceEvent, Boolean>(){

            public Boolean apply(InterfaceEvent e) {
                return InterfaceUtilities.usesMaps(e);
            }
        };
        return IterableExtensions.exists(InterfaceUtilities.getAllInterfaceEvents(s), (Functions.Function1)_function);
    }

    public static boolean usesMaps(InterfaceEvent e) {
        boolean _or = false;
        Functions.Function1<Parameter, Type> _function = new Functions.Function1<Parameter, Type>(){

            public Type apply(Parameter it) {
                return it.getType();
            }
        };
        Functions.Function1<Type, Boolean> _function_1 = new Functions.Function1<Type, Boolean>(){

            public Boolean apply(Type t) {
                return TypeUtilities.usesMaps((EObject)t);
            }
        };
        boolean _exists = IterableExtensions.exists((Iterable)ListExtensions.map(e.getParameters(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (_exists) {
            _or = true;
        } else {
            boolean _xifexpression = false;
            _xifexpression = e instanceof Command ? TypeUtilities.usesMaps((EObject)((Command)e).getType()) : false;
            _or = _xifexpression;
        }
        return _or;
    }
}

